/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Sheduler;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Sheduler.SchedTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Schedule {
    private boolean enabled = false;
    private String name;
    private Long performOn = 0L;
    private boolean performed = false;
    private List<String> commands = new ArrayList<String>();
    private List<String> tempCommands = new ArrayList<String>();
    private List<String> minPlayerCommands = new ArrayList<String>();
    private boolean repeatable = false;
    private boolean randomize = false;
    private boolean duplicateRandomize = false;
    private boolean singleLinear = false;
    private long delay = 0L;
    private Long lastPerformedOn = 0L;
    private List<SchedTime> time = new ArrayList<SchedTime>();
    private Integer MinPlayer = null;
    private Integer MaxPlayer = null;
    private Boolean playerAmountFeedback = true;
    private double commandDelay = 0.0;
    private boolean randomPlayer = false;
    Pattern placeholderKeepPatern = Pattern.compile("(\\{\\%)([^\\\"^\\%^ ]+)(\\%\\})(\\B)");

    public Schedule(String string) {
        this.name = string;
    }

    public void reset() {
        this.performOn = 0L;
        this.performed = false;
        this.commands = new ArrayList<String>();
        this.repeatable = false;
        this.delay = 0L;
        this.randomize = false;
        this.duplicateRandomize = false;
        this.singleLinear = false;
        this.MinPlayer = null;
        this.MaxPlayer = null;
    }

    public String getDuplicatedRandomCommand() {
        this.tempCommands.clear();
        this.tempCommands.addAll(this.commands);
        if (this.tempCommands.isEmpty()) {
            return null;
        }
        Collections.shuffle(this.tempCommands);
        return this.tempCommands.get(0) != null ? this.tempCommands.get(0) : null;
    }

    public String getRandomCommand() {
        if (this.tempCommands.isEmpty()) {
            this.tempCommands.addAll(this.commands);
            Collections.shuffle(this.tempCommands);
        }
        if (this.tempCommands.isEmpty()) {
            return null;
        }
        return this.tempCommands.get(0) != null ? this.tempCommands.remove(0) : null;
    }

    public String getSingleLinearCommand() {
        if (this.tempCommands.isEmpty()) {
            this.tempCommands.addAll(this.commands);
        }
        if (this.tempCommands.isEmpty()) {
            return null;
        }
        return this.tempCommands.get(0) != null ? this.tempCommands.remove(0) : null;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> list2) {
        Object object;
        this.commands = list2;
        int n = 0;
        while (n < this.commands.size()) {
            String object2 = list2.get(n);
            if (object2 instanceof LinkedHashMap) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)((Object)object2);
                object = "";
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    object = String.valueOf(object) + (String)entry.getKey() + ": " + (String)entry.getValue();
                }
                list2.set(n, (String)object);
            } else {
                list2.set(n, list2.get(n));
            }
            ++n;
        }
        for (String string : list2) {
            if (!string.contains("[randomPlayer]")) continue;
            this.randomPlayer = true;
            break;
        }
        Double d = 0.0;
        for (String string : this.commands) {
            if (!string.startsWith("delay!")) continue;
            object = string.split(" ");
            try {
                d = d + Double.parseDouble(object[1]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.commandDelay = d;
    }

    public boolean isPerformed() {
        return this.performed;
    }

    public void setPerformed(boolean bl) {
        this.performed = bl;
    }

    public boolean isPlayerAmountOk() {
        return this.isPlayerMinOk() && this.isPlayerMaxOk();
    }

    public boolean isPlayerMinOk() {
        return this.getMinPlayer() == null || Bukkit.getOnlinePlayers().size() >= this.getMinPlayer();
    }

    public boolean isPlayerMaxOk() {
        return this.getMaxPlayer() == null || Bukkit.getOnlinePlayers().size() <= this.getMaxPlayer();
    }

    public boolean itsTimeToPerform() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (this.performOn != 0L && this.performOn < l) {
            if (!this.isPerformed()) {
                return true;
            }
            if (this.repeatable) {
                this.setPerformed(false);
                this.recalculateNext();
            }
        }
        if (!this.time.isEmpty()) {
            for (SchedTime schedTime : this.time) {
                if (!schedTime.isNow()) continue;
                bl = true;
                if (this.isPerformed()) continue;
                if (!this.repeatable) {
                    schedTime.setDone(true);
                }
                return true;
            }
            if (!bl) {
                this.setPerformed(false);
            }
            return false;
        }
        if (this.repeatable) {
            this.setPerformed(false);
            this.recalculateNext();
        }
        return false;
    }

    public void recalculateNext() {
        if (this.delay != 0L) {
            this.updateNextPerform();
        } else if (!this.time.isEmpty()) {
            Long l = Long.MAX_VALUE;
            for (SchedTime schedTime : this.time) {
                if (schedTime.getNextMili() - System.currentTimeMillis() <= 0L || l <= schedTime.getNextMili()) continue;
                l = schedTime.getNextMili();
            }
            if (l != Long.MAX_VALUE) {
                this.performOn = l;
            }
        }
    }

    public Long getPerformOn() {
        this.recalculateNext();
        return this.performOn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public Long getLastPerformedOn() {
        return this.lastPerformedOn;
    }

    public void setLastPerformedOn() {
        if (this.time.isEmpty()) {
            this.setLastPerformedOn(System.currentTimeMillis());
        } else {
            this.recalculateNext();
        }
    }

    public void setLastPerformedOn(Long l) {
        this.lastPerformedOn = l;
        this.updateNextPerform();
    }

    private void updateNextPerform() {
        this.performOn = (this.lastPerformedOn == 0L ? System.currentTimeMillis() : this.lastPerformedOn) + this.delay * 1000L;
    }

    public List<SchedTime> getTime() {
        return this.time;
    }

    public void setTime(List<SchedTime> list2) {
        this.time = list2;
    }

    public Integer getMinPlayer() {
        return this.MinPlayer;
    }

    public void setMinPlayer(Integer n) {
        this.MinPlayer = n;
    }

    public Integer getMaxPlayer() {
        return this.MaxPlayer;
    }

    public void setMaxPlayer(Integer n) {
        this.MaxPlayer = n;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean bl) {
        this.randomize = bl;
    }

    public void safePerform() {
        this.setLastPerformedOn();
        this.recalculateNext();
        this.setPerformed(true);
        if (!this.isPlayerAmountOk()) {
            if (this.isPlayerAmountFeedback().booleanValue()) {
                CMIMessages.consoleMessage((String)("Skipping schedule " + this.getName() + " due to player amount"));
            }
            if (!this.isPlayerMinOk()) {
                CMI.getInstance().getSpecializedCommandManager().processCmds(this.getMinPlayerCommands());
            }
            return;
        }
        this.perform();
    }

    public void perform() {
        Player player = null;
        if (this.randomPlayer) {
            player = this.getRandomPlayer();
        }
        if (this.isSingleLinear()) {
            String string = this.getSingleLinearCommand();
            if (string != null) {
                List<String> list2 = new ArrayList<String>();
                list2.add(string);
                list2 = this.updateSchedCmds(list2, player);
                CMI.getInstance().getSpecializedCommandManager().processCmds(list2);
            }
            return;
        }
        if (this.isRandomize()) {
            String string = this.getRandomCommand();
            if (string != null) {
                List<String> list3 = new ArrayList<String>();
                list3.add(string);
                list3 = this.updateSchedCmds(list3, player);
                CMI.getInstance().getSpecializedCommandManager().processCmds(list3);
            }
            return;
        }
        if (this.isDuplicateRandomize()) {
            String string = this.getDuplicatedRandomCommand();
            if (string != null) {
                List<String> list4 = new ArrayList<String>();
                list4.add(string);
                list4 = this.updateSchedCmds(list4, player);
                CMI.getInstance().getSpecializedCommandManager().processCmds(list4);
            }
            return;
        }
        List<String> list5 = new ArrayList<String>(this.getCommands());
        list5 = this.updateSchedCmds(list5, player);
        CMI.getInstance().getSpecializedCommandManager().processCmds(list5, player);
    }

    public List<String> updateSchedCmds(List<String> list2, Player player) {
        int n = 0;
        while (n < list2.size()) {
            String string = list2.get(n);
            string = CMIChatColor.translate((String)string);
            if (player != null) {
                string = string.replace("[randomPlayer]", player.getName());
            }
            if (!string.startsWith("allPlayers!")) {
                string = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string);
            }
            list2.set(n, string);
            ++n;
        }
        return list2;
    }

    public Player getRandomPlayer() {
        Player player = null;
        if (this.randomPlayer) {
            ArrayList<Player> arrayList = new ArrayList<Player>();
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                arrayList.add(player2);
            }
            int n = 0;
            Collections.shuffle(arrayList, new Random(System.currentTimeMillis()));
            while (n < arrayList.size()) {
                player = (Player)arrayList.get(n);
                ++n;
                if (!PermissionsManager.CMIPerm.scheduler_exclude.hasSetPermission((CommandSender)player, new String[0])) break;
                player = null;
            }
        }
        return player;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Boolean isPlayerAmountFeedback() {
        return this.playerAmountFeedback;
    }

    public void setPlayerAmountFeedback(Boolean bl) {
        this.playerAmountFeedback = bl;
    }

    public Double getTotalCommandDelay() {
        return this.commandDelay;
    }

    public boolean isSingleLinear() {
        return this.singleLinear;
    }

    public void setSingleLinear(boolean bl) {
        this.singleLinear = bl;
    }

    public boolean isDuplicateRandomize() {
        return this.duplicateRandomize;
    }

    public void setDuplicateRandomize(boolean bl) {
        this.duplicateRandomize = bl;
    }

    public List<String> getMinPlayerCommands() {
        return this.minPlayerCommands;
    }

    public void setMinPlayerCommands(List<String> list2) {
        this.minPlayerCommands = list2;
    }
}

