/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import co.uk.silvania.cities.digicoin.DigiCoin;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_DigiCoin
extends AbstractEconomy {
    private final Logger log;
    private final String name = "DigiCoin";
    private Plugin plugin = null;
    private DigiCoin economy = null;

    public Economy_DigiCoin(Plugin plugin) {
        Plugin digicoin;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (digicoin = plugin.getServer().getPluginManager().getPlugin("DigiCoin")) != null && digicoin.isEnabled()) {
            this.economy = (DigiCoin)digicoin;
            this.log.info(String.format("[Economy] %s hooked.", "DigiCoin"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null;
    }

    @Override
    public String getName() {
        return "DigiCoin";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public String format(double amount) {
        if (amount == 1.0) {
            return String.format("%d %s", amount, this.currencyNameSingular());
        }
        return String.format("%d %s", amount, this.currencyNamePlural());
    }

    @Override
    public String currencyNamePlural() {
        return "coins";
    }

    @Override
    public String currencyNameSingular() {
        return "coin";
    }

    @Override
    public boolean hasAccount(String playerName) {
        return true;
    }

    @Override
    public double getBalance(String playerName) {
        return this.economy.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String message;
        EconomyResponse.ResponseType rt;
        if (this.economy.removeBalance(playerName, amount).booleanValue()) {
            rt = EconomyResponse.ResponseType.SUCCESS;
            message = null;
        } else {
            rt = EconomyResponse.ResponseType.FAILURE;
            message = "Not enough money.";
        }
        return new EconomyResponse(amount, this.getBalance(playerName), rt, message);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String message;
        EconomyResponse.ResponseType rt;
        if (this.economy.addBalance(playerName, amount).booleanValue()) {
            rt = EconomyResponse.ResponseType.SUCCESS;
            message = null;
        } else {
            rt = EconomyResponse.ResponseType.FAILURE;
            message = "Failed to deposit balance.";
        }
        return new EconomyResponse(amount, this.getBalance(playerName), rt, message);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "DigiCoin does not support bank accounts");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return true;
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return false;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_DigiCoin economy = null;

        public EconomyServerListener(Economy_DigiCoin economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin digicoin;
            if (this.economy.economy == null && (digicoin = event.getPlugin()).getDescription().getName().equals("DigiCoin")) {
                this.economy.economy = (DigiCoin)digicoin;
                Economy_DigiCoin.this.log.info(String.format("[Economy] %s hooked.", "DigiCoin"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("DigiCoin")) {
                this.economy.economy = null;
                Economy_DigiCoin.this.log.info(String.format("[Economy] %s unhooked.", "DigiCoin"));
            }
        }
    }
}

