/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.command.properties;

import com.github.steveice10.mc.protocol.data.game.command.properties.CommandProperties;

public class FloatProperties
implements CommandProperties {
    private final float min;
    private final float max;

    public FloatProperties() {
        this.min = -3.4028235E38f;
        this.max = Float.MAX_VALUE;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatProperties)) {
            return false;
        }
        FloatProperties other = (FloatProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        return Float.compare(this.getMax(), other.getMax()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FloatProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getMin());
        result = result * 59 + Float.floatToIntBits(this.getMax());
        return result;
    }

    public String toString() {
        return "FloatProperties(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    public FloatProperties(float min, float max) {
        this.min = min;
        this.max = max;
    }
}

