/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.common.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundCustomPayloadPacket
implements MinecraftPacket {
    @NonNull
    private final String channel;
    private final byte @NonNull [] data;

    public ClientboundCustomPayloadPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.channel = helper.readString(in);
        this.data = helper.readByteArray(in, ByteBuf::readableBytes);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.channel);
        out.writeBytes(this.data);
    }

    @NonNull
    public String getChannel() {
        return this.channel;
    }

    public byte @NonNull [] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCustomPayloadPacket)) {
            return false;
        }
        ClientboundCustomPayloadPacket other = (ClientboundCustomPayloadPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundCustomPayloadPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public String toString() {
        return "ClientboundCustomPayloadPacket(channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public ClientboundCustomPayloadPacket withChannel(@NonNull String channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.channel == channel ? this : new ClientboundCustomPayloadPacket(channel, this.data);
    }

    public ClientboundCustomPayloadPacket withData(byte @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ClientboundCustomPayloadPacket(this.channel, data);
    }

    public ClientboundCustomPayloadPacket(@NonNull String channel, byte @NonNull [] data) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.channel = channel;
        this.data = data;
    }
}

