/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.common.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.ResourcePackStatus;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

public class ServerboundResourcePackPacket
implements MinecraftPacket {
    @NonNull
    private final UUID id;
    @NonNull
    private final ResourcePackStatus status;

    public ServerboundResourcePackPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.id = helper.readUUID(in);
        this.status = ResourcePackStatus.from(helper.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeUUID(out, this.id);
        helper.writeVarInt(out, this.status.ordinal());
    }

    @NonNull
    public UUID getId() {
        return this.id;
    }

    @NonNull
    public ResourcePackStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundResourcePackPacket)) {
            return false;
        }
        ServerboundResourcePackPacket other = (ServerboundResourcePackPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ResourcePackStatus this$status = this.getStatus();
        ResourcePackStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundResourcePackPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ResourcePackStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundResourcePackPacket(id=" + this.getId() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public ServerboundResourcePackPacket withId(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.id == id ? this : new ServerboundResourcePackPacket(id, this.status);
    }

    public ServerboundResourcePackPacket withStatus(@NonNull ResourcePackStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return this.status == status ? this : new ServerboundResourcePackPacket(this.id, status);
    }

    public ServerboundResourcePackPacket(@NonNull UUID id, @NonNull ResourcePackStatus status) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.id = id;
        this.status = status;
    }
}

