/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ClientboundPlayerInfoRemovePacket
implements MinecraftPacket {
    private final List<UUID> profileIds;

    public ClientboundPlayerInfoRemovePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.profileIds = new ArrayList<UUID>();
        int numIds = helper.readVarInt(in);
        for (int i = 0; i < numIds; ++i) {
            this.profileIds.add(helper.readUUID(in));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.profileIds.size());
        for (UUID id : this.profileIds) {
            helper.writeUUID(out, id);
        }
    }

    public List<UUID> getProfileIds() {
        return this.profileIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerInfoRemovePacket)) {
            return false;
        }
        ClientboundPlayerInfoRemovePacket other = (ClientboundPlayerInfoRemovePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UUID> this$profileIds = this.getProfileIds();
        List<UUID> other$profileIds = other.getProfileIds();
        return !(this$profileIds == null ? other$profileIds != null : !((Object)this$profileIds).equals(other$profileIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerInfoRemovePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UUID> $profileIds = this.getProfileIds();
        result = result * 59 + ($profileIds == null ? 43 : ((Object)$profileIds).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerInfoRemovePacket(profileIds=" + this.getProfileIds() + ")";
    }

    public ClientboundPlayerInfoRemovePacket withProfileIds(List<UUID> profileIds) {
        return this.profileIds == profileIds ? this : new ClientboundPlayerInfoRemovePacket(profileIds);
    }

    public ClientboundPlayerInfoRemovePacket(List<UUID> profileIds) {
        this.profileIds = profileIds;
    }
}

