/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.PositionElement;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class ClientboundPlayerPositionPacket
implements MinecraftPacket {
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    private final int teleportId;
    @NonNull
    private final List<PositionElement> relative;

    public ClientboundPlayerPositionPacket(double x, double y, double z, float yaw, float pitch, int teleportId, PositionElement ... relative) {
        this(x, y, z, yaw, pitch, teleportId, Arrays.asList(relative != null ? relative : new PositionElement[]{}));
    }

    public ClientboundPlayerPositionPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        this.relative = new ArrayList<PositionElement>();
        short flags = in.readUnsignedByte();
        for (PositionElement element : PositionElement.values()) {
            int bit = 1 << element.ordinal();
            if ((flags & bit) != bit) continue;
            this.relative.add(element);
        }
        this.teleportId = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        int flags = 0;
        for (PositionElement element : this.relative) {
            flags |= 1 << element.ordinal();
        }
        out.writeByte(flags);
        helper.writeVarInt(out, this.teleportId);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getTeleportId() {
        return this.teleportId;
    }

    @NonNull
    public List<PositionElement> getRelative() {
        return this.relative;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerPositionPacket)) {
            return false;
        }
        ClientboundPlayerPositionPacket other = (ClientboundPlayerPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (this.getTeleportId() != other.getTeleportId()) {
            return false;
        }
        List<PositionElement> this$relative = this.getRelative();
        List<PositionElement> other$relative = other.getRelative();
        return !(this$relative == null ? other$relative != null : !((Object)this$relative).equals(other$relative));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + this.getTeleportId();
        List<PositionElement> $relative = this.getRelative();
        result = result * 59 + ($relative == null ? 43 : ((Object)$relative).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerPositionPacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", teleportId=" + this.getTeleportId() + ", relative=" + this.getRelative() + ")";
    }

    public ClientboundPlayerPositionPacket withX(double x) {
        return this.x == x ? this : new ClientboundPlayerPositionPacket(x, this.y, this.z, this.yaw, this.pitch, this.teleportId, this.relative);
    }

    public ClientboundPlayerPositionPacket withY(double y) {
        return this.y == y ? this : new ClientboundPlayerPositionPacket(this.x, y, this.z, this.yaw, this.pitch, this.teleportId, this.relative);
    }

    public ClientboundPlayerPositionPacket withZ(double z) {
        return this.z == z ? this : new ClientboundPlayerPositionPacket(this.x, this.y, z, this.yaw, this.pitch, this.teleportId, this.relative);
    }

    public ClientboundPlayerPositionPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundPlayerPositionPacket(this.x, this.y, this.z, yaw, this.pitch, this.teleportId, this.relative);
    }

    public ClientboundPlayerPositionPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundPlayerPositionPacket(this.x, this.y, this.z, this.yaw, pitch, this.teleportId, this.relative);
    }

    public ClientboundPlayerPositionPacket withTeleportId(int teleportId) {
        return this.teleportId == teleportId ? this : new ClientboundPlayerPositionPacket(this.x, this.y, this.z, this.yaw, this.pitch, teleportId, this.relative);
    }

    public ClientboundPlayerPositionPacket withRelative(@NonNull List<PositionElement> relative) {
        if (relative == null) {
            throw new NullPointerException("relative is marked non-null but is null");
        }
        return this.relative == relative ? this : new ClientboundPlayerPositionPacket(this.x, this.y, this.z, this.yaw, this.pitch, this.teleportId, relative);
    }

    public ClientboundPlayerPositionPacket(double x, double y, double z, float yaw, float pitch, int teleportId, @NonNull List<PositionElement> relative) {
        if (relative == null) {
            throw new NullPointerException("relative is marked non-null but is null");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.teleportId = teleportId;
        this.relative = relative;
    }
}

