/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundContainerSetContentPacket
implements MinecraftPacket {
    private final int containerId;
    private final int stateId;
    private final @Nullable ItemStack @NonNull [] items;
    @Nullable
    private final ItemStack carriedItem;

    public ClientboundContainerSetContentPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.containerId = in.readUnsignedByte();
        this.stateId = helper.readVarInt(in);
        this.items = new ItemStack[helper.readVarInt(in)];
        for (int index = 0; index < this.items.length; ++index) {
            this.items[index] = helper.readItemStack(in);
        }
        this.carriedItem = helper.readItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeByte(this.containerId);
        helper.writeVarInt(out, this.stateId);
        helper.writeVarInt(out, this.items.length);
        for (ItemStack item : this.items) {
            helper.writeItemStack(out, item);
        }
        helper.writeItemStack(out, this.carriedItem);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public @Nullable ItemStack @NonNull [] getItems() {
        return this.items;
    }

    @Nullable
    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetContentPacket)) {
            return false;
        }
        ClientboundContainerSetContentPacket other = (ClientboundContainerSetContentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        return !(this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundContainerSetContentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundContainerSetContentPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", items=" + Arrays.deepToString(this.getItems()) + ", carriedItem=" + this.getCarriedItem() + ")";
    }

    public ClientboundContainerSetContentPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetContentPacket(containerId, this.stateId, this.items, this.carriedItem);
    }

    public ClientboundContainerSetContentPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ClientboundContainerSetContentPacket(this.containerId, stateId, this.items, this.carriedItem);
    }

    public ClientboundContainerSetContentPacket withItems(@Nullable ItemStack @NonNull [] items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return this.items == items ? this : new ClientboundContainerSetContentPacket(this.containerId, this.stateId, items, this.carriedItem);
    }

    public ClientboundContainerSetContentPacket withCarriedItem(@Nullable ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ClientboundContainerSetContentPacket(this.containerId, this.stateId, this.items, carriedItem);
    }

    public ClientboundContainerSetContentPacket(int containerId, int stateId, @Nullable ItemStack @NonNull [] items, @Nullable ItemStack carriedItem) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.containerId = containerId;
        this.stateId = stateId;
        this.items = items;
        this.carriedItem = carriedItem;
    }
}

