/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundPlaceGhostRecipePacket
implements MinecraftPacket {
    private final int containerId;
    @NonNull
    private final String recipeId;

    public ClientboundPlaceGhostRecipePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.containerId = in.readByte();
        this.recipeId = helper.readString(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeByte(this.containerId);
        helper.writeString(out, this.recipeId);
    }

    public int getContainerId() {
        return this.containerId;
    }

    @NonNull
    public String getRecipeId() {
        return this.recipeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlaceGhostRecipePacket)) {
            return false;
        }
        ClientboundPlaceGhostRecipePacket other = (ClientboundPlaceGhostRecipePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        String this$recipeId = this.getRecipeId();
        String other$recipeId = other.getRecipeId();
        return !(this$recipeId == null ? other$recipeId != null : !this$recipeId.equals(other$recipeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlaceGhostRecipePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        String $recipeId = this.getRecipeId();
        result = result * 59 + ($recipeId == null ? 43 : $recipeId.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlaceGhostRecipePacket(containerId=" + this.getContainerId() + ", recipeId=" + this.getRecipeId() + ")";
    }

    public ClientboundPlaceGhostRecipePacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundPlaceGhostRecipePacket(containerId, this.recipeId);
    }

    public ClientboundPlaceGhostRecipePacket withRecipeId(@NonNull String recipeId) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        return this.recipeId == recipeId ? this : new ClientboundPlaceGhostRecipePacket(this.containerId, recipeId);
    }

    public ClientboundPlaceGhostRecipePacket(int containerId, @NonNull String recipeId) {
        if (recipeId == null) {
            throw new NullPointerException("recipeId is marked non-null but is null");
        }
        this.containerId = containerId;
        this.recipeId = recipeId;
    }
}

