/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.chunk.ChunkBiomeData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ClientboundChunksBiomesPacket
implements MinecraftPacket {
    private final List<ChunkBiomeData> chunkBiomeData;

    public ClientboundChunksBiomesPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.chunkBiomeData = new ArrayList<ChunkBiomeData>();
        int length = helper.readVarInt(in);
        for (int i = 0; i < length; ++i) {
            long raw = in.readLong();
            this.chunkBiomeData.add(new ChunkBiomeData((int)raw, (int)(raw >> 32), helper.readByteArray(in)));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.chunkBiomeData.size());
        for (ChunkBiomeData entry : this.chunkBiomeData) {
            long raw = (long)entry.getX() & 0xFFFFFFFFL | ((long)entry.getZ() & 0xFFFFFFFFL) << 32;
            out.writeLong(raw);
            helper.writeByteArray(out, entry.getBuffer());
        }
    }

    public List<ChunkBiomeData> getChunkBiomeData() {
        return this.chunkBiomeData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundChunksBiomesPacket)) {
            return false;
        }
        ClientboundChunksBiomesPacket other = (ClientboundChunksBiomesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ChunkBiomeData> this$chunkBiomeData = this.getChunkBiomeData();
        List<ChunkBiomeData> other$chunkBiomeData = other.getChunkBiomeData();
        return !(this$chunkBiomeData == null ? other$chunkBiomeData != null : !((Object)this$chunkBiomeData).equals(other$chunkBiomeData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundChunksBiomesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ChunkBiomeData> $chunkBiomeData = this.getChunkBiomeData();
        result = result * 59 + ($chunkBiomeData == null ? 43 : ((Object)$chunkBiomeData).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundChunksBiomesPacket(chunkBiomeData=" + this.getChunkBiomeData() + ")";
    }

    public ClientboundChunksBiomesPacket(List<ChunkBiomeData> chunkBiomeData) {
        this.chunkBiomeData = chunkBiomeData;
    }
}

