/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.chat.numbers.NumberFormat;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ObjectiveAction;
import com.github.steveice10.mc.protocol.data.game.scoreboard.ScoreType;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundSetObjectivePacket
implements MinecraftPacket {
    @NonNull
    private final String name;
    @NonNull
    private final ObjectiveAction action;
    @Nullable
    private final Component displayName;
    @Nullable
    private final ScoreType type;
    @Nullable
    private final NumberFormat numberFormat;

    public ClientboundSetObjectivePacket(@NonNull String name) {
        this(name, ObjectiveAction.REMOVE, null, null, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public ClientboundSetObjectivePacket(@NonNull String name, @NonNull ObjectiveAction action, @Nullable Component displayName, @Nullable ScoreType type, @Nullable NumberFormat numberFormat) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (!(action != ObjectiveAction.ADD && action != ObjectiveAction.UPDATE || displayName != null && type != null)) {
            throw new IllegalArgumentException("ADD and UPDATE actions require display name and type.");
        }
        this.name = name;
        this.action = action;
        this.displayName = displayName;
        this.type = type;
        this.numberFormat = numberFormat;
    }

    public ClientboundSetObjectivePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.name = helper.readString(in);
        this.action = ObjectiveAction.from(in.readByte());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            this.displayName = helper.readComponent(in);
            this.type = ScoreType.from(helper.readVarInt(in));
            this.numberFormat = helper.readNullable(in, helper::readNumberFormat);
        } else {
            this.displayName = null;
            this.type = null;
            this.numberFormat = null;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.name);
        out.writeByte(this.action.ordinal());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            helper.writeComponent(out, this.displayName);
            helper.writeVarInt(out, this.type.ordinal());
            helper.writeNullable(out, this.numberFormat, helper::writeNumberFormat);
        }
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public ObjectiveAction getAction() {
        return this.action;
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public ScoreType getType() {
        return this.type;
    }

    @Nullable
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetObjectivePacket)) {
            return false;
        }
        ClientboundSetObjectivePacket other = (ClientboundSetObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ObjectiveAction this$action = this.getAction();
        ObjectiveAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ScoreType this$type = this.getType();
        ScoreType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        NumberFormat this$numberFormat = this.getNumberFormat();
        NumberFormat other$numberFormat = other.getNumberFormat();
        return !(this$numberFormat == null ? other$numberFormat != null : !this$numberFormat.equals(other$numberFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetObjectivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ObjectiveAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ScoreType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        NumberFormat $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : $numberFormat.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSetObjectivePacket(name=" + this.getName() + ", action=" + (Object)((Object)this.getAction()) + ", displayName=" + this.getDisplayName() + ", type=" + (Object)((Object)this.getType()) + ", numberFormat=" + this.getNumberFormat() + ")";
    }

    public ClientboundSetObjectivePacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientboundSetObjectivePacket(name, this.action, this.displayName, this.type, this.numberFormat);
    }

    public ClientboundSetObjectivePacket withAction(@NonNull ObjectiveAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundSetObjectivePacket(this.name, action, this.displayName, this.type, this.numberFormat);
    }

    public ClientboundSetObjectivePacket withDisplayName(@Nullable Component displayName) {
        return this.displayName == displayName ? this : new ClientboundSetObjectivePacket(this.name, this.action, displayName, this.type, this.numberFormat);
    }

    public ClientboundSetObjectivePacket withType(@Nullable ScoreType type) {
        return this.type == type ? this : new ClientboundSetObjectivePacket(this.name, this.action, this.displayName, type, this.numberFormat);
    }

    public ClientboundSetObjectivePacket withNumberFormat(@Nullable NumberFormat numberFormat) {
        return this.numberFormat == numberFormat ? this : new ClientboundSetObjectivePacket(this.name, this.action, this.displayName, this.type, numberFormat);
    }
}

