/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.helper;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.incubator.channel.uring.IOUring;

public class TransportHelper {
    public static TransportMethod determineTransportMethod() {
        if (TransportHelper.isClassAvailable("io.netty.incubator.channel.uring.IOUring") && IOUring.isAvailable()) {
            return TransportMethod.IO_URING;
        }
        if (TransportHelper.isClassAvailable("io.netty.channel.epoll.Epoll") && Epoll.isAvailable()) {
            return TransportMethod.EPOLL;
        }
        if (TransportHelper.isClassAvailable("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable()) {
            return TransportMethod.KQUEUE;
        }
        return TransportMethod.NIO;
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static enum TransportMethod {
        NIO,
        EPOLL,
        KQUEUE,
        IO_URING;

    }
}

