/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v419.serializer;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v407.serializer.ItemStackResponseSerializer_v407;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseContainer;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseSlot;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseStatus;
import org.cloudburstmc.protocol.bedrock.packet.ItemStackResponsePacket;
import org.cloudburstmc.protocol.common.util.VarInts;

public class ItemStackResponseSerializer_v419
extends ItemStackResponseSerializer_v407 {
    public static final ItemStackResponseSerializer_v419 INSTANCE = new ItemStackResponseSerializer_v419();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponsePacket packet) {
        helper.writeArray(buffer, packet.getEntries(), (buf, response) -> {
            buf.writeByte(response.getResult().ordinal());
            VarInts.writeInt(buffer, response.getRequestId());
            if (response.getResult() != ItemStackResponseStatus.OK) {
                return;
            }
            helper.writeArray((ByteBuf)buf, response.getContainers(), (buf2, containerEntry) -> {
                helper.writeContainerSlotType((ByteBuf)buf2, containerEntry.getContainer());
                helper.writeArray((ByteBuf)buf2, containerEntry.getItems(), this::writeItemEntry);
            });
        });
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ItemStackResponsePacket packet) {
        List<ItemStackResponse> entries = packet.getEntries();
        helper.readArray(buffer, entries, buf -> {
            ItemStackResponseStatus result = ItemStackResponseStatus.values()[buf.readByte()];
            int requestId = VarInts.readInt(buf);
            if (result != ItemStackResponseStatus.OK) {
                return new ItemStackResponse(result, requestId, Collections.emptyList());
            }
            ArrayList<ItemStackResponseContainer> containerEntries = new ArrayList<ItemStackResponseContainer>();
            helper.readArray((ByteBuf)buf, containerEntries, buf2 -> {
                ContainerSlotType container = helper.readContainerSlotType((ByteBuf)buf2);
                ArrayList<ItemStackResponseSlot> itemEntries = new ArrayList<ItemStackResponseSlot>();
                helper.readArray((ByteBuf)buf2, itemEntries, byteBuf -> this.readItemEntry((ByteBuf)buf2, helper));
                return new ItemStackResponseContainer(container, itemEntries);
            });
            return new ItemStackResponse(result, requestId, containerEntries);
        });
    }
}

