/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.netty.initializer;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.BedrockPeer;
import org.cloudburstmc.protocol.bedrock.BedrockSession;
import org.cloudburstmc.protocol.bedrock.netty.codec.FrameIdCodec;
import org.cloudburstmc.protocol.bedrock.netty.codec.batch.BedrockBatchDecoder;
import org.cloudburstmc.protocol.bedrock.netty.codec.batch.BedrockBatchEncoder;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.ZlibCompressionCodec;
import org.cloudburstmc.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v1;
import org.cloudburstmc.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v2;
import org.cloudburstmc.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v3;
import org.cloudburstmc.protocol.common.util.Zlib;

public abstract class BedrockChannelInitializer<T extends BedrockSession>
extends ChannelInitializer<Channel> {
    public static final int RAKNET_MINECRAFT_ID = 254;
    private static final FrameIdCodec RAKNET_FRAME_CODEC = new FrameIdCodec(254);
    private static final BedrockBatchDecoder BATCH_DECODER = new BedrockBatchDecoder();

    protected final void initChannel(Channel channel) throws Exception {
        this.preInitChannel(channel);
        channel.pipeline().addLast("bedrock-batch-decoder", (ChannelHandler)BATCH_DECODER).addLast("bedrock-batch-encoder", (ChannelHandler)new BedrockBatchEncoder());
        this.initPacketCodec(channel);
        channel.pipeline().addLast("bedrock-peer", (ChannelHandler)this.createPeer(channel));
        this.postInitChannel(channel);
    }

    protected void preInitChannel(Channel channel) throws Exception {
        channel.pipeline().addLast("frame-id-codec", (ChannelHandler)RAKNET_FRAME_CODEC);
        int rakVersion = (Integer)channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
        switch (rakVersion) {
            case 7: 
            case 8: 
            case 9: {
                channel.pipeline().addLast("compression-codec", (ChannelHandler)new ZlibCompressionCodec(Zlib.DEFAULT));
                break;
            }
            case 10: {
                channel.pipeline().addLast("compression-codec", (ChannelHandler)new ZlibCompressionCodec(Zlib.RAW));
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported RakNet protocol version: " + rakVersion);
            }
        }
    }

    protected void postInitChannel(Channel channel) throws Exception {
    }

    protected void initPacketCodec(Channel channel) throws Exception {
        int rakVersion = (Integer)channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
        switch (rakVersion) {
            case 9: 
            case 10: 
            case 11: {
                channel.pipeline().addLast("bedrock-packet-codec", (ChannelHandler)new BedrockPacketCodec_v3());
                break;
            }
            case 8: {
                channel.pipeline().addLast("bedrock-packet-codec", (ChannelHandler)new BedrockPacketCodec_v2());
                break;
            }
            case 7: {
                channel.pipeline().addLast("bedrock-packet-codec", (ChannelHandler)new BedrockPacketCodec_v1());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported RakNet protocol version: " + rakVersion);
            }
        }
    }

    protected BedrockPeer createPeer(Channel channel) {
        return new BedrockPeer(channel, this::createSession);
    }

    protected final T createSession(BedrockPeer peer, int subClientId) {
        T session = this.createSession0(peer, subClientId);
        this.initSession(session);
        return session;
    }

    protected abstract T createSession0(BedrockPeer var1, int var2);

    protected abstract void initSession(T var1);
}

