/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.session.GeyserSession;

public class WitherEntity
extends MonsterEntity {
    public WitherEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.WITHER_AERIAL_ATTACK, (short)1);
    }

    public void setTarget1(IntEntityMetadata entityMetadata) {
        this.setTargetId(EntityDataTypes.WITHER_TARGET_A, entityMetadata);
    }

    public void setTarget2(IntEntityMetadata entityMetadata) {
        this.setTargetId(EntityDataTypes.WITHER_TARGET_B, entityMetadata);
    }

    public void setTarget3(IntEntityMetadata entityMetadata) {
        this.setTargetId(EntityDataTypes.WITHER_TARGET_C, entityMetadata);
    }

    private void setTargetId(EntityDataType<Long> entityData, IntEntityMetadata entityMetadata) {
        int entityId = entityMetadata.getPrimitiveValue();
        Entity entity = this.session.getEntityCache().getEntityByJavaId(entityId);
        if (entity != null) {
            this.dirtyMetadata.put(entityData, entity.getGeyserId());
        } else {
            this.dirtyMetadata.put(entityData, 0L);
        }
    }

    public void setInvulnerableTicks(IntEntityMetadata entityMetadata) {
        int value = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityDataTypes.WITHER_INVULNERABLE_TICKS, value);
        if (value >= 165) {
            this.dirtyMetadata.put(EntityDataTypes.WITHER_AERIAL_ATTACK, (short)0);
        } else {
            this.dirtyMetadata.put(EntityDataTypes.WITHER_AERIAL_ATTACK, (short)1);
        }
    }
}

