/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.entity.type.living.animal.TropicalFishEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextDecoration;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class TropicalFishBucketItem
extends Item {
    private static final Style LORE_STYLE = Style.style((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC);

    public TropicalFishBucketItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        super.translateNbtToBedrock(session, tag);
        tag.put(new ByteTag("AppendCustomName", 1));
        tag.put(new StringTag("CustomName", MinecraftLocale.getLocaleString("entity.minecraft.tropical_fish", session.locale())));
        Object bucketVariantTag = tag.get("BucketVariantTag");
        if (bucketVariantTag instanceof IntTag) {
            CompoundTag displayTag = (CompoundTag)tag.get("display");
            if (displayTag == null) {
                displayTag = new CompoundTag("display");
                tag.put(displayTag);
            }
            ArrayList<Tag> lore = new ArrayList<Tag>();
            int varNumber = ((IntTag)bucketVariantTag).getValue();
            int predefinedVariantId = TropicalFishEntity.getPredefinedId(varNumber);
            if (predefinedVariantId != -1) {
                TranslatableComponent tooltip = Component.translatable("entity.minecraft.tropical_fish.predefined." + predefinedVariantId, LORE_STYLE);
                lore.add(0, new StringTag("", MessageTranslator.convertMessage(tooltip, session.locale())));
            } else {
                TranslatableComponent typeTooltip = Component.translatable("entity.minecraft.tropical_fish.type." + TropicalFishEntity.getVariantName(varNumber), LORE_STYLE);
                lore.add(0, new StringTag("", MessageTranslator.convertMessage(typeTooltip, session.locale())));
                byte baseColor = TropicalFishEntity.getBaseColor(varNumber);
                byte patternColor = TropicalFishEntity.getPatternColor(varNumber);
                Component colorTooltip = Component.translatable("color.minecraft." + TropicalFishEntity.getColorName(baseColor), LORE_STYLE);
                if (baseColor != patternColor) {
                    colorTooltip = colorTooltip.append(Component.text(", ", LORE_STYLE)).append(Component.translatable("color.minecraft." + TropicalFishEntity.getColorName(patternColor), LORE_STYLE));
                }
                lore.add(1, new StringTag("", MessageTranslator.convertMessage(colorTooltip, session.locale())));
            }
            ListTag loreTag = (ListTag)displayTag.get("Lore");
            if (loreTag != null) {
                lore.addAll((Collection<Tag>)loreTag.getValue());
            }
            displayTag.put(new ListTag("Lore", lore));
        }
    }
}

