/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import com.github.steveice10.mc.protocol.data.game.advancement.Advancement;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.session.cache.AdvancementsCache;

public class GeyserAdvancement {
    private final Advancement advancement;
    private String rootId = null;

    public static GeyserAdvancement from(Advancement advancement) {
        return new GeyserAdvancement(advancement);
    }

    private GeyserAdvancement(Advancement advancement) {
        this.advancement = advancement;
    }

    public @NonNull String getId() {
        return this.advancement.getId();
    }

    public @NonNull List<List<String>> getRequirements() {
        return this.advancement.getRequirements();
    }

    public String getParentId() {
        return this.advancement.getParentId();
    }

    public Advancement.DisplayData getDisplayData() {
        return this.advancement.getDisplayData();
    }

    public String getDisplayColor() {
        Advancement.DisplayData displayData = this.getDisplayData();
        return displayData != null && displayData.getAdvancementType() == Advancement.DisplayData.AdvancementType.CHALLENGE ? "\u00a7d" : "\u00a7a";
    }

    public @NonNull String getRootId(AdvancementsCache advancementsCache) {
        if (this.rootId == null) {
            GeyserAdvancement advancement;
            this.rootId = this.advancement.getParentId() == null ? this.advancement.getId() : ((advancement = advancementsCache.getStoredAdvancements().get(this.advancement.getParentId())).getParentId() == null ? advancement.getId() : advancement.getRootId(advancementsCache));
        }
        return this.rootId;
    }
}

