/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.world.manager;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.List;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.spigot.GeyserSpigotPlugin;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntList;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntListIterator;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotNativeWorldManager;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserSpigotLegacyNativeWorldManager
extends GeyserSpigotNativeWorldManager {
    private final Int2IntMap oldToNewBlockId;

    public GeyserSpigotLegacyNativeWorldManager(GeyserSpigotPlugin plugin) {
        super((Plugin)plugin);
        IntList allBlockStates = this.adapter.getAllBlockStates();
        this.oldToNewBlockId = new Int2IntOpenHashMap(allBlockStates.size());
        ProtocolVersion serverVersion = plugin.getServerProtocolVersion();
        List protocolList = Via.getManager().getProtocolManager().getProtocolPath(GameProtocol.getJavaProtocolVersion(), serverVersion.getVersion());
        Objects.requireNonNull(protocolList, "protocolList cannot be null");
        IntListIterator intListIterator = allBlockStates.iterator();
        while (intListIterator.hasNext()) {
            int oldBlockId;
            int newBlockId = oldBlockId = ((Integer)intListIterator.next()).intValue();
            for (int i = protocolList.size() - 1; i >= 0; --i) {
                MappingData mappingData = ((ProtocolPathEntry)protocolList.get(i)).getProtocol().getMappingData();
                if (mappingData == null) continue;
                newBlockId = mappingData.getNewBlockStateId(newBlockId);
            }
            this.oldToNewBlockId.put(oldBlockId, newBlockId);
        }
    }

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        int nativeBlockId = super.getBlockAt(session, x, y, z);
        return this.oldToNewBlockId.getOrDefault(nativeBlockId, nativeBlockId);
    }

    @Override
    public boolean isLegacy() {
        return true;
    }
}

