/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;

public class SkinManager {
    public static PlayerListPacket.Entry buildCachedEntry(GeyserSession session, PlayerEntity playerEntity) {
        GameProfileData data = GameProfileData.from(playerEntity);
        SkinProvider.Skin skin = null;
        SkinProvider.Cape cape = null;
        SkinProvider.SkinGeometry geometry = SkinProvider.SkinGeometry.WIDE;
        if (data != null) {
            skin = SkinProvider.getCachedSkin(data.skinUrl());
            cape = SkinProvider.getCachedCape(data.capeUrl());
            SkinProvider.SkinGeometry skinGeometry = geometry = data.isAlex() ? SkinProvider.SkinGeometry.SLIM : SkinProvider.SkinGeometry.WIDE;
        }
        if (skin == null || cape == null) {
            SkinProvider.SkinData fallbackSkinData = SkinProvider.determineFallbackSkinData(playerEntity.getUuid());
            if (skin == null) {
                skin = fallbackSkinData.skin();
                geometry = fallbackSkinData.geometry();
            }
            if (cape == null) {
                cape = fallbackSkinData.cape();
            }
        }
        return SkinManager.buildEntryManually(session, playerEntity.getUuid(), playerEntity.getUsername(), playerEntity.getGeyserId(), skin, cape, geometry);
    }

    public static PlayerListPacket.Entry buildEntryManually(GeyserSession session, UUID uuid, String username, long geyserId, SkinProvider.Skin skin, SkinProvider.Cape cape, SkinProvider.SkinGeometry geometry) {
        SerializedSkin serializedSkin = SkinManager.getSkin(skin.getTextureUrl(), skin, cape, geometry);
        String xuid = "";
        GeyserSession playerSession = GeyserImpl.getInstance().connectionByUuid(uuid);
        if (playerSession != null) {
            xuid = playerSession.getAuthData().xuid();
        }
        PlayerListPacket.Entry entry = session.getPlayerEntity().getUuid().equals(uuid) ? new PlayerListPacket.Entry(session.getAuthData().uuid()) : new PlayerListPacket.Entry(uuid);
        entry.setName(username);
        entry.setEntityId(geyserId);
        entry.setSkin(serializedSkin);
        entry.setXuid(xuid);
        entry.setPlatformChatId("");
        entry.setTeacher(false);
        entry.setTrustedSkin(true);
        return entry;
    }

    public static void sendSkinPacket(GeyserSession session, PlayerEntity entity, SkinProvider.SkinData skinData) {
        SkinProvider.Skin skin = skinData.skin();
        SkinProvider.Cape cape = skinData.cape();
        SkinProvider.SkinGeometry geometry = skinData.geometry();
        if (entity.getUuid().equals(session.getPlayerEntity().getUuid())) {
            PlayerListPacket.Entry updatedEntry = SkinManager.buildEntryManually(session, entity.getUuid(), entity.getUsername(), entity.getGeyserId(), skin, cape, geometry);
            PlayerListPacket playerAddPacket = new PlayerListPacket();
            playerAddPacket.setAction(PlayerListPacket.Action.ADD);
            playerAddPacket.getEntries().add(updatedEntry);
            session.sendUpstreamPacket(playerAddPacket);
        } else {
            PlayerSkinPacket packet = new PlayerSkinPacket();
            packet.setUuid(entity.getUuid());
            packet.setOldSkinName("");
            packet.setNewSkinName(skin.getTextureUrl());
            packet.setSkin(SkinManager.getSkin(skin.getTextureUrl(), skin, cape, geometry));
            packet.setTrustedSkin(true);
            session.sendUpstreamPacket(packet);
        }
    }

    private static SerializedSkin getSkin(String skinId, SkinProvider.Skin skin, SkinProvider.Cape cape, SkinProvider.SkinGeometry geometry) {
        return SerializedSkin.of(skinId, "", geometry.geometryName(), ImageData.of(skin.getSkinData()), Collections.emptyList(), ImageData.of(cape.capeData()), geometry.geometryData(), "", true, false, false, cape.capeId(), skinId);
    }

    public static void requestAndHandleSkinAndCape(PlayerEntity entity, GeyserSession session, Consumer<SkinProvider.SkinAndCape> skinAndCapeConsumer) {
        SkinProvider.requestSkinData(entity).whenCompleteAsync((skinData, throwable) -> {
            if (skinData == null) {
                if (skinAndCapeConsumer != null) {
                    skinAndCapeConsumer.accept(null);
                }
                return;
            }
            if (skinData.geometry() != null) {
                SkinManager.sendSkinPacket(session, entity, skinData);
            }
            if (skinAndCapeConsumer != null) {
                skinAndCapeConsumer.accept(new SkinProvider.SkinAndCape(skinData.skin(), skinData.cape()));
            }
        });
    }

    public static void handleBedrockSkin(PlayerEntity playerEntity, BedrockClientData clientData) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        if (geyser.getConfig().isDebugMode()) {
            geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.register", playerEntity.getUsername(), playerEntity.getUuid()));
        }
        try {
            byte[] skinBytes = Base64.getDecoder().decode(clientData.getSkinData().getBytes(StandardCharsets.UTF_8));
            byte[] capeBytes = clientData.getCapeData();
            byte[] geometryNameBytes = Base64.getDecoder().decode(clientData.getGeometryName().getBytes(StandardCharsets.UTF_8));
            byte[] geometryBytes = Base64.getDecoder().decode(clientData.getGeometryData().getBytes(StandardCharsets.UTF_8));
            if (skinBytes.length <= 65536 && !clientData.isPersonaSkin()) {
                SkinProvider.storeBedrockSkin(playerEntity.getUuid(), clientData.getSkinId(), skinBytes);
                SkinProvider.storeBedrockGeometry(playerEntity.getUuid(), geometryNameBytes, geometryBytes);
            } else if (geyser.getConfig().isDebugMode()) {
                geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.skin.bedrock.fail", playerEntity.getUsername()));
                geyser.getLogger().debug("The size of '" + playerEntity.getUsername() + "' skin is: " + clientData.getSkinImageWidth() + "x" + clientData.getSkinImageHeight());
            }
            if (!clientData.getCapeId().equals("")) {
                SkinProvider.storeBedrockCape(clientData.getCapeId(), capeBytes);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Failed to cache skin for bedrock user (" + playerEntity.getUsername() + "): ", e);
        }
    }

    public record GameProfileData(String skinUrl, String capeUrl, boolean isAlex) {
        public static @Nullable GameProfileData from(CompoundTag tag) {
            ListTag texturesTag;
            Object t = tag.get("Properties");
            if (!(t instanceof CompoundTag)) {
                return null;
            }
            CompoundTag propertiesTag = (CompoundTag)t;
            Object t2 = propertiesTag.get("textures");
            if (!(t2 instanceof ListTag) || (texturesTag = (ListTag)t2).size() == 0) {
                return null;
            }
            Object t3 = texturesTag.get(0);
            if (!(t3 instanceof CompoundTag)) {
                return null;
            }
            CompoundTag texturesData = (CompoundTag)t3;
            Object t4 = texturesData.get("Value");
            if (!(t4 instanceof StringTag)) {
                return null;
            }
            StringTag skinDataValue = (StringTag)t4;
            try {
                return GameProfileData.loadFromJson(skinDataValue.getValue());
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for tag " + tag);
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        public static @Nullable GameProfileData from(PlayerEntity entity) {
            String texturesProperty = entity.getTexturesProperty();
            if (texturesProperty == null) {
                return null;
            }
            try {
                return GameProfileData.loadFromJson(texturesProperty);
            }
            catch (Exception exception) {
                if (entity instanceof SkullPlayerEntity) {
                    SkullPlayerEntity skullEntity = (SkullPlayerEntity)entity;
                    GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for skull at " + skullEntity.getSkullPosition() + " with Value: " + texturesProperty);
                } else {
                    GeyserImpl.getInstance().getLogger().debug("Something went wrong while processing skin for " + entity.getUsername() + " with Value: " + texturesProperty);
                }
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    exception.printStackTrace();
                }
                return null;
            }
        }

        public static @Nullable GameProfileData loadFromJson(String encodedJson) throws IOException, IllegalArgumentException {
            JsonNode capeUrlNode;
            JsonNode skinObject;
            try {
                skinObject = GeyserImpl.JSON_MAPPER.readTree(new String(Base64.getDecoder().decode(encodedJson), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                GeyserImpl.getInstance().getLogger().debug("Invalid base64 encoded skin entry: " + encodedJson);
                return null;
            }
            JsonNode textures = skinObject.get("textures");
            if (textures == null) {
                return null;
            }
            JsonNode skinTexture = textures.get("SKIN");
            if (skinTexture == null) {
                return null;
            }
            JsonNode skinUrlNode = skinTexture.get("url");
            if (skinUrlNode == null || !skinUrlNode.isTextual()) {
                return null;
            }
            String skinUrl = skinUrlNode.asText().replace("http://", "https://");
            boolean isAlex = skinTexture.has("metadata");
            String capeUrl = null;
            JsonNode capeTexture = textures.get("CAPE");
            if (capeTexture != null && (capeUrlNode = capeTexture.get("url")) != null && capeUrlNode.isTextual()) {
                capeUrl = capeUrlNode.asText().replace("http://", "https://");
            }
            return new GameProfileData(skinUrl, capeUrl, isAlex);
        }
    }
}

