/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.Style;

public final class TextDecoration {
    private final String translationKey;
    private final Style style;
    private final Set<Parameter> parameters;

    public TextDecoration(CompoundTag tag) {
        this.translationKey = (String)((Tag)tag.get("translation_key")).getValue();
        CompoundTag styleTag = (CompoundTag)tag.get("style");
        Style.Builder builder = Style.style();
        if (styleTag != null) {
            Object italic;
            StringTag color = (StringTag)styleTag.get("color");
            if (color != null) {
                builder.color(NamedTextColor.NAMES.value(color.getValue()));
            }
            if ((italic = styleTag.get("italic")) != null && ((Number)((Tag)italic).getValue()).byteValue() == 1) {
                builder.decorate(org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextDecoration.ITALIC);
            }
        }
        this.style = builder.build();
        this.parameters = EnumSet.noneOf(Parameter.class);
        ListTag parameters = (ListTag)tag.get("parameters");
        for (Tag parameter : parameters) {
            this.parameters.add(Parameter.valueOf(((String)parameter.getValue()).toUpperCase(Locale.ROOT)));
        }
    }

    public String translationKey() {
        return this.translationKey;
    }

    public Style style() {
        return this.style;
    }

    public Set<Parameter> parameters() {
        return this.parameters;
    }

    public String toString() {
        return "TextDecoration{translationKey='" + this.translationKey + "', style=" + this.style + ", parameters=" + this.parameters + "}";
    }

    public static enum Parameter {
        CONTENT,
        SENDER,
        TARGET;

    }
}

