/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundSetBeaconPacket;
import java.util.OptionalInt;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.BeaconPaymentAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.geysermc.geyser.inventory.BeaconContainer;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntSets;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class BeaconInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public BeaconInventoryTranslator() {
        super(1, new BlockInventoryHolder("minecraft:beacon", org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.BEACON, new String[0]){

            @Override
            protected boolean checkInteractionPosition(GeyserSession session) {
                return true;
            }

            @Override
            public void openInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
                if (!((BeaconContainer)inventory).isUsingRealBlock()) {
                    InventoryUtils.closeInventory(session, inventory.getJavaId(), false);
                    return;
                }
                super.openInventory(translator, session, inventory);
            }
        }, UIInventoryUpdater.INSTANCE);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        BeaconContainer beaconContainer = (BeaconContainer)inventory;
        switch (key) {
            case 0: {
                break;
            }
            case 1: {
                beaconContainer.setPrimaryId(value == -1 ? 0 : value);
                break;
            }
            case 2: {
                beaconContainer.setSecondaryId(value == -1 ? 0 : value);
            }
        }
        Vector3i position = inventory.getHolderPosition();
        NbtMapBuilder builder = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putString("CustomName", inventory.getTitle()).putString("id", "Beacon").putInt("primary", beaconContainer.getPrimaryId()).putInt("secondary", beaconContainer.getSecondaryId());
        BlockEntityDataPacket packet = new BlockEntityDataPacket();
        packet.setBlockPosition(position);
        packet.setData(builder.build());
        session.sendUpstreamPacket(packet);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Inventory inventory) {
        return action.getType() == ItemStackRequestActionType.BEACON_PAYMENT;
    }

    @Override
    public ItemStackResponse translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        BeaconPaymentAction beaconPayment = (BeaconPaymentAction)request.getActions()[0];
        ServerboundSetBeaconPacket packet = new ServerboundSetBeaconPacket(this.toJava(beaconPayment.getPrimaryEffect()), this.toJava(beaconPayment.getSecondaryEffect()));
        session.sendDownstreamGamePacket(packet);
        return BeaconInventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, IntSets.emptySet()));
    }

    private OptionalInt toJava(int effectChoice) {
        return effectChoice == 0 ? OptionalInt.empty() : OptionalInt.of(effectChoice - 1);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        if (slotInfoData.getContainer() == ContainerSlotType.BEACON_PAYMENT) {
            return 0;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.BEACON_PAYMENT, 27);
        }
        return super.javaSlotToBedrockContainer(slot);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 0) {
            return 27;
        }
        return super.javaSlotToBedrock(slot);
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new BeaconContainer(name, windowId, this.size, containerType, playerInventory);
    }
}

