/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import java.util.Collections;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BaseInventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.InventoryUtils;

public class LecternInventoryTranslator
extends BaseInventoryTranslator {
    private final InventoryUpdater updater = new InventoryUpdater();

    public LecternInventoryTranslator() {
        super(1);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        if (key == 0) {
            LecternContainer lecternContainer = (LecternContainer)inventory;
            lecternContainer.setCurrentBedrockPage(value / 2);
            lecternContainer.setBlockEntityTag(lecternContainer.getBlockEntityTag().toBuilder().putInt("page", lecternContainer.getCurrentBedrockPage()).build());
            BlockEntityUtils.updateBlockEntity(session, lecternContainer.getBlockEntityTag(), lecternContainer.getPosition());
        }
    }

    @Override
    public void updateInventory(GeyserSession session, Inventory inventory) {
        GeyserItemStack itemStack = inventory.getItem(0);
        if (!itemStack.isEmpty()) {
            this.updateBook(session, inventory, itemStack);
        }
    }

    @Override
    public void updateSlot(GeyserSession session, Inventory inventory, int slot) {
        this.updater.updateSlot(this, session, inventory, slot);
        if (slot == 0) {
            this.updateBook(session, inventory, inventory.getItem(0));
        }
    }

    private void updateBook(GeyserSession session, Inventory inventory, GeyserItemStack book) {
        LecternContainer lecternContainer = (LecternContainer)inventory;
        if (session.isDroppingLecternBook()) {
            ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getJavaId(), 3);
            session.sendDownstreamGamePacket(packet);
            session.setDroppingLecternBook(false);
            InventoryUtils.closeInventory(session, inventory.getJavaId(), false);
        } else if (lecternContainer.getBlockEntityTag() == null) {
            NbtMap blockEntityTag;
            boolean shouldRefresh;
            CompoundTag tag = book.getNbt();
            Vector3i position = session.getLastInteractionBlockPosition();
            boolean bl = shouldRefresh = !session.getGeyser().getWorldManager().shouldExpectLecternHandled(session) && !session.getLecternCache().contains(position);
            if (tag != null) {
                int pagesSize = ((ListTag)tag.get("pages")).size();
                ItemData itemData = book.getItemData(session);
                NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), pagesSize);
                lecternTag.putCompound("book", NbtMap.builder().putByte("Count", (byte)itemData.getCount()).putShort("Damage", (short)0).putString("Name", "minecraft:written_book").putCompound("tag", itemData.getTag()).build());
                lecternTag.putInt("page", lecternContainer.getCurrentBedrockPage());
                blockEntityTag = lecternTag.build();
            } else {
                NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 1);
                NbtMapBuilder bookTag = NbtMap.builder().putByte("Count", (byte)1).putShort("Damage", (short)0).putString("Name", "minecraft:writable_book").putCompound("tag", NbtMap.builder().putList("pages", NbtType.COMPOUND, Collections.singletonList(NbtMap.builder().putString("photoname", "").putString("text", "").build())).build());
                blockEntityTag = lecternTag.putCompound("book", bookTag.build()).build();
            }
            lecternContainer.setBlockEntityTag(blockEntityTag);
            lecternContainer.setPosition(position);
            if (shouldRefresh) {
                BlockEntityUtils.updateBlockEntity(session, blockEntityTag, position);
                session.getLecternCache().add(position);
                ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(lecternContainer.getJavaId());
                session.sendDownstreamGamePacket(closeWindowPacket);
                InventoryUtils.closeInventory(session, inventory.getJavaId(), false);
            }
        }
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new LecternContainer(name, windowId, this.size, containerType, playerInventory);
    }
}

