/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.List;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.registry.type.ItemMapping;

public final class CustomItemTranslator {
    public static @Nullable ItemDefinition getCustomItem(CompoundTag nbt, ItemMapping mapping) {
        int n;
        boolean checkDamage;
        int n2;
        if (nbt == null) {
            return null;
        }
        List<Pair<CustomItemOptions, ItemDefinition>> customMappings = mapping.getCustomItemOptions();
        if (customMappings.isEmpty()) {
            return null;
        }
        Object t = nbt.get("CustomModelData");
        if (t instanceof IntTag) {
            IntTag customModelDataTag = (IntTag)t;
            n2 = customModelDataTag.getValue();
        } else {
            n2 = 0;
        }
        int customModelData = n2;
        boolean bl = checkDamage = mapping.getJavaItem().maxDamage() > 0;
        if (!checkDamage) {
            n = 0;
        } else {
            Object object = nbt.get("Damage");
            if (object instanceof IntTag) {
                IntTag damageTag = (IntTag)object;
                n = damageTag.getValue();
            } else {
                n = 0;
            }
        }
        int damage = n;
        boolean unbreakable = checkDamage && !CustomItemTranslator.isDamaged(nbt, damage);
        for (Pair pair : customMappings) {
            OptionalInt damagePredicate;
            CustomItemOptions options = (CustomItemOptions)pair.key();
            if (!checkDamage ? options.unbreakable() != TriState.NOT_SET || options.damagePredicate().isPresent() : unbreakable && options.unbreakable() == TriState.FALSE || (damagePredicate = options.damagePredicate()).isPresent() && damage < damagePredicate.getAsInt()) continue;
            OptionalInt customModelDataOption = options.customModelData();
            if (customModelDataOption.isPresent() && customModelData < customModelDataOption.getAsInt()) continue;
            if (options.defaultItem()) {
                return null;
            }
            return (ItemDefinition)pair.value();
        }
        return null;
    }

    private static boolean isDamaged(CompoundTag nbt, int damage) {
        return CustomItemTranslator.isDamagableItem(nbt) && damage > 0;
    }

    private static boolean isDamagableItem(CompoundTag nbt) {
        Number number;
        Object object;
        Object unbreakableTag = nbt.get("Unbreakable");
        return unbreakableTag == null || !((object = ((Tag)unbreakableTag).getValue()) instanceof Number) || (number = (Number)object).byteValue() == 0;
    }

    private CustomItemTranslator() {
    }
}

