/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import java.util.Set;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.packet.ChangeDimensionPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEffectPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerActionPacket;
import org.cloudburstmc.protocol.bedrock.packet.StopSoundPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.ChunkCache;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.EntityUtils;

public class DimensionUtils {
    private static int BEDROCK_NETHER_ID = 1;
    public static final String BEDROCK_FOG_HELL = "minecraft:fog_hell";
    public static final String OVERWORLD = "minecraft:overworld";
    public static final String NETHER = "minecraft:the_nether";
    public static final String THE_END = "minecraft:the_end";

    public static void switchDimension(GeyserSession session, String javaDimension) {
        int bedrockDimension = DimensionUtils.javaToBedrock(javaDimension);
        String previousDimension = session.getDimension();
        SessionPlayerEntity player = session.getPlayerEntity();
        session.getChunkCache().clear();
        session.getEntityCache().removeAllEntities();
        session.getItemFrameCache().clear();
        if (session.getLecternCache() != null) {
            session.getLecternCache().clear();
        }
        session.getLodestoneCache().clear();
        session.getPistonCache().clear();
        session.getSkullCache().clear();
        if (session.getServerRenderDistance() > 32 && !session.isEmulatePost1_13Logic()) {
            session.getGeyser().getLogger().debug("Applying dimension switching workaround for Bedrock render distance of " + session.getServerRenderDistance());
            ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
            chunkRadiusUpdatedPacket.setRadius(32);
            session.sendUpstreamPacket(chunkRadiusUpdatedPacket);
        }
        Vector3f pos = Vector3f.from(0.0f, 32767.0f, 0.0f);
        ChangeDimensionPacket changeDimensionPacket = new ChangeDimensionPacket();
        changeDimensionPacket.setDimension(bedrockDimension);
        changeDimensionPacket.setRespawn(true);
        changeDimensionPacket.setPosition(pos);
        session.sendUpstreamPacket(changeDimensionPacket);
        session.setDimension(javaDimension);
        DimensionUtils.setBedrockDimension(session, javaDimension);
        ((Entity)player).setPosition(pos);
        session.setSpawned(false);
        session.setLastChunkPosition(null);
        Set<Effect> entityEffects = session.getEffectCache().getEntityEffects();
        for (Effect effect : entityEffects) {
            MobEffectPacket mobEffectPacket = new MobEffectPacket();
            mobEffectPacket.setEvent(MobEffectPacket.Event.REMOVE);
            mobEffectPacket.setRuntimeEntityId(player.getGeyserId());
            mobEffectPacket.setEffectId(EntityUtils.toBedrockEffectId(effect));
            session.sendUpstreamPacket(mobEffectPacket);
        }
        entityEffects.clear();
        StopSoundPacket stopSoundPacket = new StopSoundPacket();
        stopSoundPacket.setStoppingAllSound(true);
        stopSoundPacket.setSoundName("");
        session.sendUpstreamPacket(stopSoundPacket);
        PlayerActionPacket ackPacket = new PlayerActionPacket();
        ackPacket.setRuntimeEntityId(player.getGeyserId());
        ackPacket.setAction(PlayerActionType.DIMENSION_CHANGE_SUCCESS);
        ackPacket.setBlockPosition(Vector3i.ZERO);
        ackPacket.setResultPosition(Vector3i.ZERO);
        ackPacket.setFace(0);
        session.sendUpstreamPacket(ackPacket);
        ChunkUtils.sendEmptyChunks(session, player.getPosition().toInt(), 3, true);
        if (DimensionUtils.isCustomBedrockNetherId()) {
            if (NETHER.equals(javaDimension)) {
                session.sendFog(BEDROCK_FOG_HELL);
            } else if (NETHER.equals(previousDimension)) {
                session.removeFog(BEDROCK_FOG_HELL);
            }
        }
    }

    public static void setBedrockDimension(GeyserSession session, String javaDimension) {
        ChunkCache chunkCache = session.getChunkCache();
        chunkCache.setBedrockDimension(switch (javaDimension) {
            case THE_END -> BedrockDimension.THE_END;
            case NETHER -> {
                if (DimensionUtils.isCustomBedrockNetherId()) {
                    yield BedrockDimension.THE_END;
                }
                yield BedrockDimension.THE_NETHER;
            }
            default -> BedrockDimension.OVERWORLD;
        });
    }

    public static int javaToBedrock(BedrockDimension dimension) {
        if (dimension == BedrockDimension.THE_NETHER) {
            return BEDROCK_NETHER_ID;
        }
        if (dimension == BedrockDimension.THE_END) {
            return 2;
        }
        return 0;
    }

    public static int javaToBedrock(String javaDimension) {
        return switch (javaDimension) {
            case NETHER -> BEDROCK_NETHER_ID;
            case THE_END -> 2;
            default -> 0;
        };
    }

    public static void changeBedrockNetherId(boolean isAboveNetherBedrockBuilding) {
        BEDROCK_NETHER_ID = isAboveNetherBedrockBuilding ? 2 : 1;
    }

    public static String getTemporaryDimension(String currentDimension, String newDimension) {
        if (DimensionUtils.isCustomBedrockNetherId()) {
            return DimensionUtils.javaToBedrock(newDimension) == 2 ? OVERWORLD : NETHER;
        }
        return DimensionUtils.javaToBedrock(currentDimension) == 0 ? NETHER : OVERWORLD;
    }

    public static boolean isCustomBedrockNetherId() {
        return BEDROCK_NETHER_ID == 2;
    }
}

