/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.packet.common.serverbound.ServerboundCustomPayloadPacket;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import org.geysermc.geyser.session.GeyserSession;

public class PluginMessageUtils {
    private static final byte[] GEYSER_BRAND_DATA;

    public static byte[] getGeyserBrandData() {
        return GEYSER_BRAND_DATA;
    }

    public static void sendMessage(GeyserSession session, String channel, byte[] data) {
        session.sendDownstreamPacket(new ServerboundCustomPayloadPacket(channel, data));
    }

    private static byte[] writeVarInt(int value) {
        byte[] data = new byte[PluginMessageUtils.getVarIntLength(value)];
        int index = 0;
        do {
            byte temp = (byte)(value & 0x7F);
            if ((value >>>= 7) != 0) {
                temp = (byte)(temp | 0x80);
            }
            data[index] = temp;
            ++index;
        } while (value != 0);
        return data;
    }

    private static int getVarIntLength(int number) {
        if ((number & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((number & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((number & 0xFFE00000) == 0) {
            return 3;
        }
        if ((number & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static {
        byte[] data = "Geyser".getBytes(Charsets.UTF_8);
        GEYSER_BRAND_DATA = ByteBuffer.allocate(data.length + PluginMessageUtils.getVarIntLength(data.length)).put(PluginMessageUtils.writeVarInt(data.length)).put(data).array();
    }
}

