/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.apocalypse;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.api.ApocalypseEndEvent;
import com.ericdebouwer.zombieapocalypse.api.ApocalypseStartEvent;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseWorld;
import com.ericdebouwer.zombieapocalypse.config.Message;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ApocalypseManager {
    private File apoFile;
    private FileConfiguration apoConfig;
    private final String UNTIL_KEY = ".until";
    private final String MOB_CAP_KEY = ".mobcap";
    private final List<ApocalypseWorld> apocalypseWorlds = new ArrayList<ApocalypseWorld>();
    private final Map<String, BukkitTask> apoEnders = new HashMap<String, BukkitTask>();
    private final ZombieApocalypse plugin;

    public ApocalypseManager(ZombieApocalypse plugin) {
        this.plugin = plugin;
        this.createFile();
        if (this.apoConfig == null) {
            return;
        }
        for (String key : this.apoConfig.getKeys(false)) {
            long endTime = this.apoConfig.getLong(key + ".until");
            long now = Instant.now().getEpochSecond();
            if (endTime > 0L && endTime < now) continue;
            int mobCap = this.apoConfig.getInt(key + ".mobcap", Bukkit.getMonsterSpawnLimit());
            this.startApocalypse(key, endTime, mobCap, false);
        }
    }

    private void createFile() {
        try {
            this.apoFile = new File(this.plugin.getDataFolder(), "apocalypse.yml");
            if (!this.apoFile.exists()) {
                this.apoFile.getParentFile().mkdirs();
                this.apoFile.createNewFile();
            }
            this.apoConfig = YamlConfiguration.loadConfiguration((File)this.apoFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.plugin.getLogger().warning("Failed to load apocalypse data! Removed 'apocalypse.yml' and restart the server!");
        }
    }

    private void saveConfig() {
        try {
            for (ApocalypseWorld world : this.apocalypseWorlds) {
                this.apoConfig.set(world.getWorldName() + ".until", (Object)world.getEndEpochSecond());
                this.apoConfig.set(world.getWorldName() + ".mobcap", (Object)world.getMobCap());
            }
            this.apoConfig.save(this.apoFile);
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        for (World world : Bukkit.getWorlds()) {
            Optional<ApocalypseWorld> apoWorld = this.getApoWorld(world.getName());
            if (!apoWorld.isPresent()) continue;
            for (Player player : world.getPlayers()) {
                apoWorld.get().removePlayer(player);
            }
        }
        this.saveConfig();
    }

    private void addEndDelay(String worldName, long endTime) {
        long now = Instant.now().getEpochSecond();
        long delay = (endTime - now) * 20L;
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.endApocalypse(worldName, true), delay);
        this.apoEnders.put(worldName, task);
    }

    public Optional<ApocalypseWorld> getApoWorld(String worldName) {
        return this.apocalypseWorlds.stream().filter(w -> w.getWorldName().equals(worldName)).findFirst();
    }

    public boolean isApocalypse(String worldName) {
        return this.getApoWorld(worldName).isPresent();
    }

    public boolean startApocalypse(String worldName, long endTime, boolean broadCast) {
        World world = Bukkit.getWorld((String)worldName);
        int mobCap = world == null ? Bukkit.getMonsterSpawnLimit() : world.getMonsterSpawnLimit();
        return this.startApocalypse(worldName, endTime, mobCap, broadCast);
    }

    public boolean startApocalypse(String worldName, long endTime, int mobCap, boolean broadCast) {
        World world;
        if (this.isApocalypse(worldName)) {
            return false;
        }
        File potentialWorld = new File(Bukkit.getServer().getWorldContainer(), worldName);
        if (!potentialWorld.exists() || !potentialWorld.isDirectory()) {
            return false;
        }
        ApocalypseWorld apoWorld = new ApocalypseWorld(this.plugin, worldName, endTime, mobCap);
        ApocalypseStartEvent event = new ApocalypseStartEvent(apoWorld);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            Bukkit.removeBossBar((NamespacedKey)apoWorld.getBossBar().getKey());
            return true;
        }
        this.apocalypseWorlds.add(apoWorld);
        if (endTime > 0L) {
            this.addEndDelay(worldName, endTime);
            apoWorld.startCountDown();
        }
        if ((world = Bukkit.getWorld((String)worldName)) == null) {
            return true;
        }
        world.setMonsterSpawnLimit(mobCap);
        for (Player player : world.getPlayers()) {
            if (broadCast) {
                this.plugin.getConfigManager().sendMessage((CommandSender)player, Message.START_BROADCAST, (ImmutableMap<String, String>)ImmutableMap.of((Object)"world_name", (Object)worldName));
            }
            apoWorld.addPlayer(player);
        }
        return true;
    }

    public void setMobCap(String worldName, int mobCap) {
        Optional<ApocalypseWorld> apoWorld = this.getApoWorld(worldName);
        if (!apoWorld.isPresent()) {
            return;
        }
        apoWorld.get().setMobCap(mobCap);
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return;
        }
        world.setMonsterSpawnLimit(mobCap);
    }

    public boolean endApocalypse(String worldName, boolean broadCast) {
        Optional<ApocalypseWorld> apoWorld = this.getApoWorld(worldName);
        if (!apoWorld.isPresent()) {
            return false;
        }
        ApocalypseEndEvent event = new ApocalypseEndEvent(apoWorld.get());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        Optional.ofNullable(this.apoEnders.remove(worldName)).ifPresent(BukkitTask::cancel);
        this.apocalypseWorlds.remove(apoWorld.get());
        this.apoConfig.set(worldName, null);
        apoWorld.get().endCountDown();
        this.saveConfig();
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return true;
        }
        world.setMonsterSpawnLimit(-1);
        for (Player player : world.getPlayers()) {
            apoWorld.get().removePlayer(player);
            if (!broadCast) continue;
            this.plugin.getConfigManager().sendMessage((CommandSender)player, Message.END_BROADCAST, (ImmutableMap<String, String>)ImmutableMap.of((Object)"world_name", (Object)worldName));
        }
        if (this.plugin.getConfigManager().isRemoveZombiesOnEnd()) {
            for (Zombie zombie : world.getEntitiesByClass(Zombie.class)) {
                if (zombie.getEquipment() != null && !zombie.getEquipment().getItemInMainHand().getType().isAir() || !Objects.equals(zombie.getCustomName(), this.plugin.getZombieFactory().getWrapper(ZombieType.getType(zombie)).getCustomName())) continue;
                zombie.remove();
            }
        }
        return true;
    }

    public void reload() {
        for (ApocalypseWorld apoWorld : this.apocalypseWorlds) {
            apoWorld.reloadBossBar();
        }
    }
}

