/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.apocalypse;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.api.Apocalypse;
import com.ericdebouwer.zombieapocalypse.config.Message;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ApocalypseWorld
implements Apocalypse {
    private final String worldName;
    private final long endEpochSecond;
    private KeyedBossBar bossBar;
    private int mobCap;
    private BukkitTask barCountDown;
    private final ZombieApocalypse plugin;

    public ApocalypseWorld(ZombieApocalypse plugin, String worldName, long endTime, int mobCap) {
        this.plugin = plugin;
        this.worldName = worldName;
        this.endEpochSecond = endTime;
        this.mobCap = mobCap;
        this.loadBossBar(1.0);
    }

    public void reloadBossBar() {
        List players = this.bossBar.getPlayers();
        double progress = this.bossBar.getProgress();
        this.bossBar.removeAll();
        this.loadBossBar(progress);
        for (Player player : players) {
            this.bossBar.addPlayer(player);
        }
    }

    private void loadBossBar(double oldProgress) {
        NamespacedKey nameKey = new NamespacedKey((Plugin)this.plugin, "apocalypsebar-" + this.worldName.replaceAll("[^a-zA-Z0-9/._-]", ""));
        String barTitle = this.plugin.getConfigManager().getString(Message.BOSS_BAR_TITLE);
        this.bossBar = this.plugin.getServer().createBossBar(nameKey, barTitle, BarColor.PURPLE, BarStyle.SOLID, new BarFlag[0]);
        if (this.plugin.getConfigManager().isBossBarFog()) {
            this.bossBar.addFlag(BarFlag.CREATE_FOG);
        }
        this.bossBar.setProgress(oldProgress);
        this.bossBar.setVisible(this.plugin.getConfigManager().doBossBar());
    }

    @Override
    public void addPlayer(@Nonnull Player player) {
        this.bossBar.addPlayer(player);
    }

    @Override
    public void removePlayer(@Nonnull Player player) {
        this.bossBar.removePlayer(player);
    }

    public void startCountDown() {
        double STEPS = 120.0;
        long now = Instant.now().getEpochSecond();
        int period = (int)Math.ceil((double)(this.endEpochSecond - now) / 120.0 * 20.0);
        this.barCountDown = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            double progress = this.bossBar.getProgress() - 0.008333333333333333;
            if (progress >= 0.0) {
                this.bossBar.setProgress(progress);
            }
        }, (long)period, (long)period);
    }

    public void endCountDown() {
        if (this.barCountDown != null) {
            this.barCountDown.cancel();
        }
        this.barCountDown = null;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public long getEndEpochSecond() {
        return this.endEpochSecond;
    }

    public KeyedBossBar getBossBar() {
        return this.bossBar;
    }

    @Override
    public int getMobCap() {
        return this.mobCap;
    }

    public void setMobCap(int mobCap) {
        this.mobCap = mobCap;
    }
}

