/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.config;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class ZombieWrapper {
    private ItemStack head;
    private String customName;
    private final ZombieType type;
    private final Map<Attribute, Double> attributes = new HashMap<Attribute, Double>();

    public ZombieWrapper(ZombieType type) {
        this(type, null);
    }

    public ZombieWrapper(ZombieType type, ConfigurationSection section) {
        ConfigurationSection attributeSection;
        this.type = type;
        if (section == null) {
            return;
        }
        String textureUrl = section.getString("head", "");
        this.head = this.getHead(textureUrl);
        this.customName = Strings.emptyToNull((String)section.getString("name"));
        if (this.customName != null) {
            this.customName = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)this.customName);
        }
        if ((attributeSection = section.getConfigurationSection("attributes")) == null) {
            return;
        }
        for (String attribute : attributeSection.getKeys(false)) {
            try {
                this.attributes.put(Attribute.valueOf((String)attribute.toUpperCase()), attributeSection.getDouble(attribute));
            }
            catch (IllegalArgumentException e) {
                ((ZombieApocalypse)JavaPlugin.getPlugin(ZombieApocalypse.class)).getLogger().info("Attribute " + attribute + " does not exist!");
            }
        }
    }

    public Zombie apply(Zombie zombie) {
        if (this.head != null) {
            zombie.getEquipment().setHelmet(this.head);
        }
        if (this.customName != null) {
            zombie.setCustomName(this.customName);
            zombie.setCustomNameVisible(true);
        }
        for (Map.Entry<Attribute, Double> attribute : this.attributes.entrySet()) {
            zombie.getAttribute(attribute.getKey()).setBaseValue(attribute.getValue().doubleValue());
            if (attribute.getKey() != Attribute.GENERIC_MAX_HEALTH) continue;
            zombie.setHealth(attribute.getValue().doubleValue());
        }
        return zombie;
    }

    private ItemStack getHead(String textureUrl) {
        if (textureUrl == null || textureUrl.isEmpty()) {
            return null;
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", textureUrl).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
            ((ZombieApocalypse)JavaPlugin.getPlugin(ZombieApocalypse.class)).getLogger().info("Zombie head could not be set, is the minecraft version correct?");
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    public String getCustomName() {
        return this.customName;
    }

    public ZombieType getType() {
        return this.type;
    }
}

