/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.zombie;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.api.ZombiePreSpawnEvent;
import com.ericdebouwer.zombieapocalypse.api.ZombieSpawnedEvent;
import com.ericdebouwer.zombieapocalypse.config.ZombieWrapper;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ZombieFactory {
    private final ZombieApocalypse plugin;
    private final Map<ZombieType, ZombieWrapper> zombieWrappers = new HashMap<ZombieType, ZombieWrapper>();

    public void reload() {
        this.zombieWrappers.clear();
    }

    public void addZombieWrapper(ZombieWrapper wrapper) {
        this.zombieWrappers.put(wrapper.getType(), wrapper);
    }

    @Nonnull
    public ZombieWrapper getWrapper(ZombieType type) {
        return this.zombieWrappers.getOrDefault((Object)type, new ZombieWrapper(type));
    }

    private ZombieType getRandomZombieType() {
        List<ZombieType> types = new ArrayList<ZombieType>(this.zombieWrappers.keySet());
        if (types.isEmpty()) {
            types = Arrays.asList(ZombieType.values());
        }
        return (ZombieType)((Object)types.get(ThreadLocalRandom.current().nextInt(types.size())));
    }

    public void spawnApocalypseZombie(Location loc) {
        ZombiePreSpawnEvent preSpawnEvent = new ZombiePreSpawnEvent(loc, this.getRandomZombieType());
        Bukkit.getServer().getPluginManager().callEvent((Event)preSpawnEvent);
        if (!preSpawnEvent.isCancelled()) {
            this.spawnZombie(loc, preSpawnEvent.getType(), ZombieSpawnedEvent.SpawnReason.APOCALYPSE);
        }
    }

    public Zombie spawnZombie(Location loc, ZombieSpawnedEvent.SpawnReason reason) {
        return this.spawnZombie(loc, this.getRandomZombieType(), reason);
    }

    public Zombie spawnZombie(Location loc, ZombieType type, ZombieSpawnedEvent.SpawnReason reason) {
        Zombie zombie = this.spawnForEnvironment(loc, type);
        zombie.setRemoveWhenFarAway(true);
        if (zombie.getVehicle() != null) {
            zombie.getVehicle().remove();
        }
        zombie = this.getWrapper(type).apply(zombie);
        if (!this.plugin.getConfigManager().doBabies()) {
            zombie.setBaby(false);
        }
        if (type == ZombieType.JUMPER) {
            zombie.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, Integer.MAX_VALUE, 5, false, false, false));
        } else if (type == ZombieType.PILLAR) {
            zombie.setBaby(false);
            int passengers = ThreadLocalRandom.current().nextInt(4) + 1;
            Zombie lowerZombie = zombie;
            for (int i = 1; i <= passengers; ++i) {
                Zombie newZombie = this.spawnZombie(loc.add(0.0, 1.5, 0.0), ZombieType.DEFAULT, ZombieSpawnedEvent.SpawnReason.ZOMBIE_EFFECT);
                newZombie.setBaby(false);
                lowerZombie.addPassenger((Entity)newZombie);
                lowerZombie = newZombie;
            }
        }
        ZombieSpawnedEvent spawnedEvent = new ZombieSpawnedEvent(loc, type, reason, zombie);
        Bukkit.getServer().getPluginManager().callEvent((Event)spawnedEvent);
        return spawnedEvent.getZombie();
    }

    private Zombie spawnForEnvironment(Location loc, ZombieType type) {
        Class environmentType;
        boolean isNether = loc.getWorld().getEnvironment() == World.Environment.NETHER;
        Class clazz = environmentType = isNether && this.plugin.getConfigManager().doNetherPigmen() ? PigZombie.class : Zombie.class;
        if (loc.getBlock().getType() == Material.WATER) {
            environmentType = Drowned.class;
        }
        Zombie zombie = this.plugin.isPaperMC() ? (Zombie)loc.getWorld().spawn(loc, environmentType, CreatureSpawnEvent.SpawnReason.NATURAL, type::set) : (Zombie)loc.getWorld().spawn(loc, environmentType, type::set);
        if (zombie.getType() == EntityType.ZOMBIE && isNether) {
            zombie.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 1, false, false));
        }
        return zombie;
    }

    public ZombieFactory(ZombieApocalypse plugin) {
        this.plugin = plugin;
    }
}

