/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.objectmapping.meta.Comment;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.config.PostProcessor;

@ConfigSerializable
public final class PluginSettings {
    @Comment(value="Do you want the plugin to check for updates on GitHub at launch?\nhttps://github.com/jpenilla/MiniMOTD")
    private boolean updateChecker = true;
    @Comment(value="Settings only applicable when running the plugin on a proxy (Velocity or Waterfall/Bungeecord)")
    private ProxySettings proxySettings = new ProxySettings();

    public @NonNull ProxySettings proxySettings() {
        return this.proxySettings;
    }

    public boolean updateChecker() {
        return this.updateChecker;
    }

    @PostProcessor
    private void lowercaseVirtualHosts() {
        HashMap<String, String> virtualHosts = new HashMap<String, String>(this.proxySettings.virtualHostConfigs);
        this.proxySettings.virtualHostConfigs.clear();
        virtualHosts.forEach((host, config) -> this.proxySettings.virtualHostConfigs.put(host.toLowerCase(Locale.ENGLISH), config));
    }

    @ConfigSerializable
    public static final class ProxySettings {
        @Comment(value="Here you can assign configs in the 'extra-configs' folder to specific virtual hosts\nEither use the name of the config in 'extra-configs', or use \"default\" to use the configuration in main.conf\n\nFormat is \"hostname:port\"=\"configName|default\"")
        private final Map<String, String> virtualHostConfigs = new HashMap<String, String>();
        @Comment(value="Set whether to enable virtual host testing mode.\nWhen enabled, MiniMOTD will print virtual host debug info to the console on each server ping.")
        private boolean virtualHostTestMode = false;

        public ProxySettings() {
            this.virtualHostConfigs.put("minigames.example.com:25565", "default");
            this.virtualHostConfigs.put("survival.example.com:25565", "survival");
            this.virtualHostConfigs.put("skyblock.example.com:25565", "skyblock");
        }

        public boolean virtualHostTestMode() {
            return this.virtualHostTestMode;
        }

        public @Nullable String findConfigStringForHost(@NonNull String host) {
            return this.virtualHostConfigs.get(host.toLowerCase(Locale.ENGLISH));
        }
    }
}

