/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.general;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.LoginSecurityConfig;
import com.lenis0012.bukkit.loginsecurity.commands.CommandAdmin;
import com.lenis0012.bukkit.loginsecurity.commands.CommandChangePass;
import com.lenis0012.bukkit.loginsecurity.commands.CommandLogin;
import com.lenis0012.bukkit.loginsecurity.commands.CommandLogout;
import com.lenis0012.bukkit.loginsecurity.commands.CommandRegister;
import com.lenis0012.bukkit.loginsecurity.commands.CommandUnregister;
import com.lenis0012.bukkit.loginsecurity.libs.bstats.bukkit.Metrics;
import com.lenis0012.bukkit.loginsecurity.libs.bstats.charts.SimplePie;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.Module;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.Updater;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.UpdaterFactory;
import com.lenis0012.bukkit.loginsecurity.modules.general.InventoryPacketListener;
import com.lenis0012.bukkit.loginsecurity.modules.general.LocationMode;
import com.lenis0012.bukkit.loginsecurity.modules.general.PlayerListener;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageModule;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GeneralModule
extends Module<LoginSecurity> {
    private LocationMode locationMode = LocationMode.DEFAULT;
    private Updater updater;

    public GeneralModule(LoginSecurity plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        this.registerCommands();
        this.registerListeners();
        this.setupUpdater();
        this.setupMetrics();
        String locationMode = LoginSecurity.getConfiguration().getLocation();
        try {
            this.locationMode = LocationMode.valueOf(locationMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.logger().log(Level.WARNING, "Using unsupported location mode '{0}'. This will do noting.", locationMode);
        }
    }

    @Override
    public void disable() {
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this.plugin, 4637);
        metrics.addCustomChart(new SimplePie("language", () -> ((LoginSecurity)this.plugin).getModule(LanguageModule.class).getTranslation().getName()));
    }

    private void setupUpdater() {
        LoginSecurityConfig config = LoginSecurity.getConfiguration();
        this.updater = config.isUpdaterEnabled() ? UpdaterFactory.provideBest((Plugin)this.plugin, ((LoginSecurity)this.plugin).getInternalClassLoader()).getUpdater((Plugin)this.plugin) : null;
    }

    private void registerCommands() {
        this.logger().log(Level.INFO, "Registering commands...");
        this.register(new CommandLogin((LoginSecurity)this.plugin), "login");
        this.register(new CommandRegister((LoginSecurity)this.plugin), "register");
        this.register(new CommandChangePass((LoginSecurity)this.plugin), "changepassword");
        this.register(new CommandLogout((LoginSecurity)this.plugin), "logout");
        this.register(new CommandUnregister((LoginSecurity)this.plugin), "unregister");
        this.register(new CommandAdmin((LoginSecurity)this.plugin), "lac");
    }

    private void registerListeners() {
        this.logger().log(Level.INFO, "Registering listeners...");
        this.register(new PlayerListener(this));
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            InventoryPacketListener.register((Plugin)this.plugin);
        }
    }

    public void checkUpdates(Player player) {
        if (this.updater != null) {
            this.updater.notifyIfUpdateAvailable(player);
        }
    }
}

