/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.storage;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.bukkit.plugin.java.JavaPlugin;

public class MigrationRunner
implements Runnable {
    private final LoginSecurity loginSecurity;
    private final DataSource dataSource;
    private final String platform;

    public MigrationRunner(LoginSecurity loginSecurity, DataSource dataSource, String platform) {
        this.loginSecurity = loginSecurity;
        this.dataSource = dataSource;
        this.platform = platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (Connection connection = this.dataSource.getConnection();){
            boolean originAutoCommit = connection.getAutoCommit();
            try {
                connection.setAutoCommit(false);
                boolean installed = this.isInstalled(connection);
                for (String migrationFileName : this.readMigrations()) {
                    String[] migrationData = migrationFileName.split(Pattern.quote("__"));
                    String version = migrationData[0];
                    String name = migrationData[1].replace("_", " ");
                    name = name.substring(0, name.length() - ".sql".length());
                    if (installed && this.isMigrationInstalled(connection, version)) continue;
                    this.loginSecurity.getLogger().log(Level.INFO, "Applying database upgrade " + version + ": " + name);
                    String content = this.getContent("sql/" + this.platform + "/" + migrationFileName);
                    Statement statement = connection.createStatement();
                    try {
                        for (String query : content.split(";")) {
                            if (query.trim().isEmpty()) continue;
                            statement.executeUpdate(query);
                        }
                        this.insertMigration(connection, version, name);
                        connection.commit();
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
            }
            finally {
                connection.setAutoCommit(originAutoCommit);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertMigration(Connection connectionm, String version, String name) throws SQLException {
        try (PreparedStatement statement = connectionm.prepareStatement("INSERT INTO ls_upgrades (version, description, applied_at) VALUES (?,?,?);");){
            statement.setString(1, version);
            statement.setString(2, name);
            statement.setTimestamp(3, Timestamp.from(Instant.now()));
            statement.executeUpdate();
        }
    }

    private boolean isMigrationInstalled(Connection connection, String version) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT version FROM ls_upgrades WHERE version=?;");){
            boolean bl;
            block12: {
                statement.setString(1, version);
                ResultSet result = statement.executeQuery();
                try {
                    bl = result.next();
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
    }

    private boolean isInstalled(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet tables = metaData.getTables(null, null, "ls_upgrades", new String[]{"TABLE"});){
            boolean bl = tables.next();
            return bl;
        }
    }

    private String getContent(String resource) {
        try {
            String line;
            InputStream input = this.loginSecurity.getResource(resource);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            reader.close();
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read resource content", e);
        }
    }

    private List<String> readMigrations() {
        ArrayList<String> migrations = new ArrayList<String>();
        try {
            JarFile jarFile = new JarFile(this.getPluginFile());
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("sql/sqlite/") || !entry.getName().contains("__")) continue;
                migrations.add(entry.getName().substring("sql/sqlite/".length()));
            }
        }
        catch (IOException e) {
            this.loginSecurity.getLogger().log(Level.SEVERE, "Failed to scan migration scripts!");
        }
        migrations.sort((o1, o2) -> {
            int i0 = Integer.valueOf(o1.split(Pattern.quote("__"))[0]);
            int i1 = Integer.valueOf(o2.split(Pattern.quote("__"))[0]);
            return Integer.compare(i0, i1);
        });
        return migrations;
    }

    private File getPluginFile() {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)this.loginSecurity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get context class loader", e);
        }
    }
}

