/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.commands.impl.cloud;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.commands.PlaceholderCommand;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CommandECloudExpansionPlaceholders
extends PlaceholderCommand {
    public CommandECloudExpansionPlaceholders() {
        super("placeholders", new String[0]);
    }

    @Override
    public void evaluate(@NotNull PlaceholderAPIPlugin plugin, @NotNull CommandSender sender, @NotNull String alias, @NotNull @Unmodifiable List<String> params) {
        if (params.isEmpty()) {
            Msg.msg(sender, "&cYou must specify the name of the expansion.");
            return;
        }
        CloudExpansion expansion = plugin.getCloudExpansionManager().findCloudExpansionByName(params.get(0)).orElse(null);
        if (expansion == null) {
            Msg.msg(sender, "&cThere is no expansion with the name: &f" + params.get(0));
            return;
        }
        List<String> placeholders = expansion.getPlaceholders();
        if (placeholders == null || placeholders.isEmpty()) {
            Msg.msg(sender, "&cThe expansion specified does not have placeholders listed.");
            return;
        }
        List partitions = Lists.partition(placeholders.stream().sorted().collect(Collectors.toList()), (int)10);
        Msg.msg(sender, "&6" + placeholders.size() + "&7 placeholders: &a", partitions.stream().map(partition -> String.join((CharSequence)", ", partition)).collect(Collectors.joining("\n")));
    }

    @Override
    public void complete(@NotNull PlaceholderAPIPlugin plugin, @NotNull CommandSender sender, @NotNull String alias, @NotNull @Unmodifiable List<String> params, @NotNull List<String> suggestions) {
        if (params.size() > 1) {
            return;
        }
        Stream<String> names = plugin.getCloudExpansionManager().getCloudExpansions().values().stream().map(CloudExpansion::getName).map(name -> name.replace(' ', '_'));
        CommandECloudExpansionPlaceholders.suggestByParameter(names, suggestions, params.isEmpty() ? null : params.get(0));
    }
}

