/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.commands;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.action.ClickAction;
import com.extendedclip.deluxemenus.action.ClickActionTask;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextComponent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.event.ClickEvent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.event.HoverEvent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.NamedTextColor;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.TextColor;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.utils.DumpUtils;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DeluxeMenusCommands
implements CommandExecutor {
    private static final TextReplacementConfig.Builder PLAYER_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<player>");
    private static final TextReplacementConfig.Builder VERSION_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<version>");
    private static final TextReplacementConfig.Builder AUTHORS_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<authors>");
    private static final TextReplacementConfig.Builder AMOUNT_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<amount>");
    private static final TextReplacementConfig.Builder MENU_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<menu>");
    private final DeluxeMenus plugin;

    public DeluxeMenusCommands(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
        this.plugin.getCommand("deluxemenus").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.plugin.sms(sender, Messages.PLUGIN_VERSION.message().replaceText((TextReplacementConfig)VERSION_REPLACER_BUILDER.replacement(this.plugin.getDescription().getVersion()).build()).replaceText((TextReplacementConfig)AUTHORS_REPLACER_BUILDER.replacement(this.plugin.getDescription().getAuthors().stream().map(author -> Component.text(author, (TextColor)NamedTextColor.WHITE)).collect(Component.toComponent(Component.text(", ", (TextColor)NamedTextColor.GRAY)))).build()));
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            if (sender.hasPermission("deluxemenus.admin")) {
                this.plugin.sms(sender, Messages.HELP_ADMIN);
                return true;
            }
            this.plugin.sms(sender, Messages.HELP);
            return true;
        }
        if (args[0].equalsIgnoreCase("dump")) {
            if (!sender.hasPermission("deluxemenus.admin")) {
                this.plugin.sms(sender, Messages.NO_PERMISSION);
                return true;
            }
            if (args.length != 2) {
                this.plugin.sms(sender, Messages.WRONG_USAGE_DUMP_COMMAND);
                return true;
            }
            String dump = "";
            try {
                dump = DumpUtils.createDump(this.plugin, args[1]);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (dump.isBlank()) {
                this.plugin.sms(sender, Messages.DUMP_FAILED);
                return true;
            }
            DumpUtils.postDump(dump).whenComplete((result, error) -> {
                if (error != null) {
                    DeluxeMenus.printStacktrace("Something went wrong while trying to create and post a dump!", error);
                    this.plugin.sms(sender, Messages.DUMP_FAILED);
                    return;
                }
                TextComponent link = (TextComponent)Component.text("https://paste.helpch.at/" + result).clickEvent(ClickEvent.openUrl("https://paste.helpch.at/" + result));
                this.plugin.sms(sender, Messages.DUMP_SUCCESS.message().append(link));
            });
            return true;
        }
        if (args[0].equalsIgnoreCase("execute")) {
            MenuHolder holder;
            Matcher ch;
            if (!sender.isOp()) {
                this.plugin.sms(sender, Messages.NO_PERMISSION);
                return true;
            }
            if (args.length < 3) {
                this.plugin.sms(sender, Messages.WRONG_USAGE_EXECUTE_COMMAND);
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(args[1]).build()));
                return true;
            }
            String executable = String.join((CharSequence)" ", Arrays.asList(args).subList(2, args.length));
            ActionType type = ActionType.getByStart(executable);
            if (type == null) {
                this.plugin.sms(sender, Messages.WRONG_ACTION_TYPE);
                return true;
            }
            executable = executable.replaceFirst(Pattern.quote(type.getIdentifier()), "").trim();
            ClickAction action = new ClickAction(type, executable);
            Matcher d = DeluxeMenusConfig.DELAY_MATCHER.matcher(executable);
            if (d.find()) {
                action.setDelay(d.group(1));
                executable = executable.replaceFirst(Pattern.quote(d.group()), "");
            }
            if ((ch = DeluxeMenusConfig.CHANCE_MATCHER.matcher(executable)).find()) {
                action.setChance(ch.group(1));
                executable = executable.replaceFirst(Pattern.quote(ch.group()), "");
            }
            action.setExecutable(executable);
            MenuHolder menuHolder = holder = Menu.getMenuHolder(target) == null ? new MenuHolder(target) : Menu.getMenuHolder(target);
            if (!action.checkChance(holder)) {
                this.plugin.sms(sender, Messages.CHANCE_FAIL);
                return true;
            }
            if (action.hasDelay()) {
                new ClickActionTask(this.plugin, target.getName(), action.getType(), action.getExecutable()).runTaskLater((Plugin)this.plugin, action.getDelay(holder));
                this.plugin.sms(sender, Messages.ACTION_TO_BE_EXECUTED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement(String.valueOf(action.getDelay(holder))).build()));
                return true;
            }
            new ClickActionTask(this.plugin, target.getName(), action.getType(), action.getExecutable()).runTask((Plugin)this.plugin);
            this.plugin.sms(sender, Messages.ACTION_EXECUTED_FOR.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("deluxemenus.reload")) {
                this.plugin.sms(sender, Messages.NO_PERMISSION);
                return true;
            }
            if (this.plugin.getConfiguration().checkConfig(null, "config.yml", false) == null) {
                this.plugin.sms(sender, Messages.RELOAD_FAIL);
                return true;
            }
            if (args.length > 1) {
                if (Menu.getMenu(args[1]) == null) {
                    this.plugin.sms(sender, Messages.INVALID_MENU.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(args[1]).build()));
                    return true;
                }
                Menu.unload(args[1]);
                if (this.plugin.getConfiguration().loadGUIMenu(args[1])) {
                    this.plugin.sms(sender, Messages.MENU_RELOADED.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(args[1]).build()));
                    return true;
                }
                this.plugin.sms(sender, Messages.MENU_NOT_RELOADED.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(args[1]).build()));
                return true;
            }
            this.plugin.clearCaches();
            this.plugin.reloadConfig();
            this.plugin.saveConfig();
            DeluxeMenus.debugLevel(this.plugin.getConfiguration().debugLevel());
            Menu.unload();
            this.plugin.getConfiguration().loadGUIMenus();
            this.plugin.sms(sender, Messages.RELOAD_SUCCESS);
            int gLoaded = Menu.getLoadedMenuSize();
            if (gLoaded == 1) {
                this.plugin.sms(sender, Messages.MENU_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement(String.valueOf(gLoaded)).build()));
            } else {
                this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement(String.valueOf(gLoaded)).build()));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (!sender.hasPermission("deluxemenus.list")) {
                this.plugin.sms(sender, Messages.NO_PERMISSION);
                return true;
            }
            Collection<Menu> menus = Menu.getAllMenus();
            if (menus == null || menus.isEmpty()) {
                this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement("There are no").build()));
                return true;
            }
            TextComponent.Builder list = Component.text();
            list.append(Component.text("The following " + menus.size() + " menus are loaded on the server:", (TextColor)NamedTextColor.GOLD).append(Component.newline()));
            if (sender instanceof ConsoleCommandSender) {
                list.append((Component)Component.newline());
                Component menusList = menus.stream().map(menu -> menu.getMenuCommands() == null || menu.getMenuCommands().isEmpty() ? (TextComponent)((TextComponent)Component.text(menu.getMenuName(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text("No menu command", (TextColor)NamedTextColor.RED)) : (TextComponent)((TextComponent)Component.text(menu.getMenuName(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text("/" + menu.getMenuCommands().get(0), (TextColor)NamedTextColor.GREEN))).collect(Component.toComponent(Component.text(" | ", (TextColor)NamedTextColor.WHITE)));
                this.plugin.sms(sender, (Component)((TextComponent.Builder)list.append(menusList)).build());
                return true;
            }
            list.append((Component)Component.text("**Hover menu name for more info**", (TextColor)NamedTextColor.GRAY));
            ((TextComponent.Builder)list.append((Component)Component.newline())).append((Component)Component.newline());
            Component menusList = menus.stream().map(menu -> menu.getMenuCommands() == null || menu.getMenuCommands().isEmpty() ? (TextComponent)Component.text(menu.getMenuName(), (TextColor)NamedTextColor.DARK_AQUA).hoverEvent(HoverEvent.showText(Component.text("No open command", (TextColor)NamedTextColor.GOLD))) : (TextComponent)((TextComponent)Component.text(menu.getMenuName(), (TextColor)NamedTextColor.DARK_AQUA).hoverEvent(HoverEvent.showText(Component.text("Open Command: ", (TextColor)NamedTextColor.GOLD).append(Component.text("/" + menu.getMenuCommands().get(0), (TextColor)NamedTextColor.YELLOW))))).clickEvent(ClickEvent.suggestCommand("/" + menu.getMenuCommands().get(0)))).collect(Component.toComponent(Component.text(", ", (TextColor)NamedTextColor.WHITE)));
            list.append(menusList);
            this.plugin.sms(sender, (Component)list.build());
            return true;
        }
        if (args[0].equalsIgnoreCase("open")) {
            Menu menu2;
            Player viewer;
            if (!sender.hasPermission("deluxemenus.open")) {
                this.plugin.sms(sender, Messages.NO_PERMISSION);
                return true;
            }
            boolean player = sender instanceof Player;
            if (args.length < 2) {
                this.plugin.sms(sender, Messages.WRONG_USAGE_OPEN_COMMAND);
                return true;
            }
            if (Menu.getAllMenus() == null || Menu.getAllMenus().isEmpty()) {
                this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement("There are no").build()));
                return true;
            }
            String placeholderPlayer = null;
            if (args.length == 3 && args[2].startsWith("-p:")) {
                if (!sender.hasPermission("deluxemenus.placeholdersfor")) {
                    this.plugin.sms(sender, Messages.NO_PERMISSION_PLAYER_ARGUMENT);
                    return true;
                }
                placeholderPlayer = args[2].replace("-p:", "");
            } else if (args.length >= 4 && args[3].startsWith("-p:")) {
                if (!sender.hasPermission("deluxemenus.placeholdersfor")) {
                    this.plugin.sms(sender, Messages.NO_PERMISSION_PLAYER_ARGUMENT);
                    return true;
                }
                placeholderPlayer = args[3].replace("-p:", "");
            }
            if (args.length >= 3) {
                if (placeholderPlayer == null) {
                    if (player && !sender.hasPermission("deluxemenus.open.others")) {
                        this.plugin.sms(sender, Messages.NO_PERMISSION);
                        return true;
                    }
                    viewer = Bukkit.getPlayer((String)args[2]);
                } else if (args.length >= 4) {
                    if (!sender.hasPermission("deluxemenus.open.others")) {
                        this.plugin.sms(sender, Messages.NO_PERMISSION);
                        return true;
                    }
                    viewer = Bukkit.getPlayer((String)args[2]);
                } else {
                    if (!player) {
                        this.plugin.sms(sender, Messages.MUST_SPECIFY_PLAYER);
                        return true;
                    }
                    viewer = (Player)sender;
                }
            } else {
                if (!player) {
                    this.plugin.sms(sender, Messages.MUST_SPECIFY_PLAYER);
                    return true;
                }
                viewer = (Player)sender;
            }
            if (viewer == null) {
                this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(args[2]).build()));
                return true;
            }
            Player placeholder = null;
            if (placeholderPlayer != null) {
                placeholder = Bukkit.getPlayer((String)placeholderPlayer);
                if (placeholder == null) {
                    this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(placeholderPlayer).build()));
                    return true;
                }
                if (placeholder.hasPermission("deluxemenus.placeholdersfor.exempt")) {
                    this.plugin.sms(sender, Messages.PLAYER_IS_EXEMPT.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(placeholderPlayer).build()));
                    return true;
                }
            }
            if ((menu2 = Menu.getMenu(args[1])) == null) {
                this.plugin.sms(sender, Messages.INVALID_MENU.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(args[1]).build()));
                return true;
            }
            menu2.openMenu(viewer, null, placeholder);
            return true;
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE);
        return true;
    }
}

