/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.dupe.marker.impl;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.dupe.marker.ItemMarker;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PDCMenuItemMarker
implements ItemMarker {
    private final NamespacedKey mark;

    public PDCMenuItemMarker(@NotNull DeluxeMenus plugin, @NotNull String mark) {
        this.mark = new NamespacedKey((Plugin)plugin, mark);
    }

    @Override
    @NotNull
    public ItemStack mark(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.set(this.mark, PersistentDataType.BYTE, (Object)1);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack unmark(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.remove(this.mark);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public boolean isMarked(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        return container.has(this.mark, PersistentDataType.BYTE);
    }
}

