/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.libs.nashorn.api.tree;

import com.extendedclip.deluxemenus.libs.nashorn.api.tree.BlockTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ExpressionTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.FunctionDeclarationTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.IdentifierTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.IdentifierTreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.StatementTreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.Tree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.TreeVisitor;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.FunctionNode;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.VarNode;
import java.util.List;

final class FunctionDeclarationTreeImpl
extends StatementTreeImpl
implements FunctionDeclarationTree {
    private final FunctionNode funcNode;
    private final IdentifierTree funcName;
    private final List<? extends ExpressionTree> params;
    private final BlockTree body;

    FunctionDeclarationTreeImpl(VarNode node, List<? extends ExpressionTree> params, BlockTree body) {
        super(node);
        assert (node.getInit() instanceof FunctionNode) : "function expected";
        this.funcNode = (FunctionNode)node.getInit();
        assert (this.funcNode.isDeclared()) : "function declaration expected";
        this.funcName = this.funcNode.isAnonymous() ? null : new IdentifierTreeImpl(node.getName());
        this.params = params;
        this.body = body;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FUNCTION;
    }

    @Override
    public IdentifierTree getName() {
        return this.funcName;
    }

    @Override
    public List<? extends ExpressionTree> getParameters() {
        return this.params;
    }

    @Override
    public BlockTree getBody() {
        return this.body;
    }

    @Override
    public boolean isStrict() {
        return this.funcNode.isStrict();
    }

    @Override
    public boolean isGenerator() {
        return this.funcNode.getKind() == FunctionNode.Kind.GENERATOR;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitFunctionDeclaration(this, data);
    }
}

