/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import com.destroystokyo.paper.event.profile.PreFillProfileEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;

public final class PaperProfileListener
implements Listener {
    @Inject
    private SimpleFloodgateApi api;

    @EventHandler
    public void onFill(PreFillProfileEvent event) {
        UUID id = event.getPlayerProfile().getId();
        if (id == null) {
            return;
        }
        FloodgatePlayer player = this.api.getPlayer(id);
        if (player == null || player.isLinked()) {
            return;
        }
        if (event.getPlayerProfile().getProperties().stream().anyMatch(prop -> "textures".equals(prop.getName()))) {
            return;
        }
        HashSet<ProfileProperty> properties = new HashSet<ProfileProperty>(event.getPlayerProfile().getProperties());
        properties.add(new ProfileProperty("textures", "", ""));
        event.setProperties(properties);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player bukkitPlayer = event.getPlayer();
        FloodgatePlayer player = this.api.getPlayer(bukkitPlayer.getUniqueId());
        if (player == null || player.isLinked()) {
            return;
        }
        PlayerProfile profile = bukkitPlayer.getPlayerProfile();
        if (profile.getProperties().stream().noneMatch(prop -> "textures".equals(prop.getName()) && prop.getValue().isEmpty() && prop.getSignature() != null && prop.getSignature().isEmpty())) {
            return;
        }
        profile.removeProperty("textures");
        bukkitPlayer.setPlayerProfile(profile);
    }
}

