/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage.channel;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinDataImpl;

public class SkinChannel
implements PluginMessageChannel {
    @Inject
    private FloodgateApi api;
    @Inject
    private FloodgateConfig config;
    @Inject
    private SkinApplier skinApplier;

    @Override
    public String getIdentifier() {
        return "floodgate:skin";
    }

    @Override
    public PluginMessageChannel.Result handleProxyCall(byte[] data, UUID sourceUuid, String sourceUsername, PluginMessageChannel.Identity sourceIdentity) {
        if (sourceIdentity == PluginMessageChannel.Identity.PLAYER) {
            PluginMessageChannel.Result result = this.handleServerCall(data, sourceUuid, sourceUsername);
            if (!result.isAllowed() && result.getReason() == null && this.config.isProxy() && ((ProxyFloodgateConfig)this.config).isSendFloodgateData()) {
                return PluginMessageChannel.Result.forward();
            }
            return result;
        }
        if (sourceIdentity == PluginMessageChannel.Identity.SERVER) {
            return PluginMessageChannel.Result.kick("Got skin data from a server?");
        }
        return PluginMessageChannel.Result.handled();
    }

    @Override
    public PluginMessageChannel.Result handleServerCall(byte[] data, UUID playerUuid, String playerUsername) {
        FloodgatePlayer floodgatePlayer = this.api.getPlayer(playerUuid);
        if (floodgatePlayer == null) {
            return PluginMessageChannel.Result.kick("Player sent skins data for a non-Floodgate player");
        }
        String message = new String(data, StandardCharsets.UTF_8);
        String[] split = message.split("\u0000");
        if (split.length != 2) {
            return PluginMessageChannel.Result.kick("Got invalid skin data");
        }
        String value = split[0];
        String signature = split[1];
        SkinDataImpl skinData = new SkinDataImpl(value, signature);
        floodgatePlayer.addProperty(PropertyKey.SKIN_UPLOADED, (Object)skinData);
        this.skinApplier.applySkin(floodgatePlayer, skinData);
        return PluginMessageChannel.Result.handled();
    }
}

