/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.listeners;

import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.schedulers.ConfirmScheduler;
import me.mattstudios.citizenscmd.utility.EnumTypes;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.Util;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class NPCClickListener
implements Listener {
    private CitizensCMD plugin;

    public NPCClickListener(CitizensCMD plugin) {
        this.plugin = plugin;
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "BungeeCord");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRightClick(NPCRightClickEvent event) {
        double price;
        NPC npc = event.getNPC();
        Player player = event.getClicker();
        if (!player.hasPermission("citizenscmd.use")) {
            return;
        }
        if (this.plugin.getDataHandler().hasCustomPermission(npc.getId()) && !player.hasPermission(this.plugin.getDataHandler().getCustomPermission(npc.getId()))) {
            return;
        }
        if (!this.plugin.getWaitingList().containsKey(player.getUniqueId().toString() + "." + npc.getId())) {
            if (!player.hasPermission("citizenscmd.bypass") && this.plugin.getCooldownHandler().onCooldown(npc.getId(), player.getUniqueId().toString())) {
                String cooldownMessage = this.plugin.getDataHandler().getNPCCooldown(npc.getId()) == -1 ? this.plugin.getLang().getMessage(Messages.ONE_TIME_CLICK) : this.plugin.getLang().getMessage(Messages.ON_COOLDOWN);
                player.sendMessage(cooldownMessage.replace("{time}", Util.getFormattedTime(this.plugin, this.plugin.getCooldownHandler().getTimeLeft(npc.getId(), player.getUniqueId().toString()), this.plugin.getDisplayFormat())));
                return;
            }
            if (this.plugin.getDataHandler().hasNoCommands(npc.getId(), EnumTypes.ClickType.RIGHT)) {
                return;
            }
        }
        if ((price = this.plugin.getDataHandler().getPrice(npc.getId())) > 0.0 && CitizensCMD.getEconomy() != null) {
            if (!this.plugin.getWaitingList().containsKey(player.getUniqueId().toString() + "." + npc.getId())) {
                String messageConfirm = this.plugin.getLang().getMessage(Messages.PAY_CONFIRM);
                messageConfirm = !this.plugin.isShift() ? messageConfirm.replace("{shift}", "") : messageConfirm.replace("{shift}", "Shift ");
                messageConfirm = messageConfirm.replace("{price}", String.valueOf(price));
                player.sendMessage(messageConfirm);
                this.plugin.getWaitingList().put(player.getUniqueId().toString() + "." + npc.getId(), true);
                new ConfirmScheduler(this.plugin, player, npc.getId()).runTaskLaterAsynchronously((Plugin)this.plugin, 300L);
                return;
            }
            if (this.plugin.isShift() && !player.isSneaking()) {
                return;
            }
            if (CitizensCMD.getEconomy().getBalance((OfflinePlayer)player) < price) {
                player.sendMessage(this.plugin.getLang().getMessage(Messages.PAY_NO_MONEY));
                return;
            }
            this.plugin.getWaitingList().remove(player.getUniqueId().toString() + "." + npc.getId());
            CitizensCMD.getEconomy().withdrawPlayer((OfflinePlayer)player, price);
            player.sendMessage(this.plugin.getLang().getMessage(Messages.PAY_COMPLETED).replace("{price}", String.valueOf(price)));
        }
        Util.doCommands(this.plugin, npc, player, EnumTypes.ClickType.RIGHT);
        if (!player.hasPermission("citizenscmd.bypass") || this.plugin.getDataHandler().getNPCCooldown(npc.getId()) != 0) {
            this.plugin.getCooldownHandler().addInteraction(npc.getId(), player.getUniqueId().toString(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLeftClick(NPCLeftClickEvent event) {
        double price;
        NPC npc = event.getNPC();
        Player player = event.getClicker();
        if (!player.hasPermission("citizenscmd.use")) {
            return;
        }
        if (this.plugin.getDataHandler().hasCustomPermission(npc.getId()) && !player.hasPermission(this.plugin.getDataHandler().getCustomPermission(npc.getId()))) {
            return;
        }
        if (!this.plugin.getWaitingList().containsKey(player.getUniqueId().toString() + "." + npc.getId())) {
            if (!player.hasPermission("citizenscmd.bypass") && this.plugin.getCooldownHandler().onCooldown(npc.getId(), player.getUniqueId().toString())) {
                String cooldownMessage = this.plugin.getDataHandler().getNPCCooldown(npc.getId()) == -1 ? this.plugin.getLang().getMessage(Messages.ONE_TIME_CLICK) : this.plugin.getLang().getMessage(Messages.ON_COOLDOWN);
                player.sendMessage(cooldownMessage.replace("{time}", Util.getFormattedTime(this.plugin, this.plugin.getCooldownHandler().getTimeLeft(npc.getId(), player.getUniqueId().toString()), this.plugin.getDisplayFormat())));
                return;
            }
            if (this.plugin.getDataHandler().hasNoCommands(npc.getId(), EnumTypes.ClickType.LEFT)) {
                return;
            }
        }
        if ((price = this.plugin.getDataHandler().getPrice(npc.getId())) > 0.0 && CitizensCMD.getEconomy() != null) {
            if (!this.plugin.getWaitingList().containsKey(player.getUniqueId().toString() + "." + npc.getId())) {
                String messageConfirm = this.plugin.getLang().getMessage(Messages.PAY_CONFIRM);
                messageConfirm = !this.plugin.isShift() ? messageConfirm.replace("{shift}", "") : messageConfirm.replace("{shift}", "Shift ");
                messageConfirm = messageConfirm.replace("{price}", String.valueOf(price));
                player.sendMessage(messageConfirm);
                this.plugin.getWaitingList().put(player.getUniqueId().toString() + "." + npc.getId(), true);
                new ConfirmScheduler(this.plugin, player, npc.getId()).runTaskLaterAsynchronously((Plugin)this.plugin, 300L);
                return;
            }
            if (this.plugin.isShift() && !player.isSneaking()) {
                return;
            }
            this.plugin.getWaitingList().remove(player.getUniqueId().toString() + "." + npc.getId());
            player.sendMessage(this.plugin.getLang().getMessage(Messages.PAY_CANCELED));
        }
        Util.doCommands(this.plugin, npc, player, EnumTypes.ClickType.LEFT);
        if (!player.hasPermission("citizenscmd.bypass") || this.plugin.getDataHandler().getNPCCooldown(npc.getId()) != 0) {
            this.plugin.getCooldownHandler().addInteraction(npc.getId(), player.getUniqueId().toString(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRemoveNPC(NPCRemoveEvent event) {
        if (!this.plugin.getDataHandler().hasNPCData(event.getNPC().getId())) {
            return;
        }
        this.plugin.getDataHandler().removeNPCData(event.getNPC().getId());
    }
}

