/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.citizenscmd.utility;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.mattstudios.citizenscmd.CitizensCMD;
import me.mattstudios.citizenscmd.metrics.bukkit.Metrics;
import me.mattstudios.citizenscmd.utility.DisplayFormat;
import me.mattstudios.citizenscmd.utility.EnumTypes;
import me.mattstudios.citizenscmd.utility.MessageUtils;
import me.mattstudios.citizenscmd.utility.Messages;
import me.mattstudios.citizenscmd.utility.TimeUtil;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Util {
    public static final String HEADER = "&c&m-&6&m-&e&m-&a&m-&b&m-&3&l CitizensCMD &b&m-&a&m-&e&m-&6&m-&c&m-";
    public static final String TAG = "&f[&3Citizens&cCMD&f]&r ";

    public static boolean npcNotSelected(CitizensCMD plugin, Player player) {
        if (CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)player) != null) {
            return false;
        }
        player.sendMessage(MessageUtils.color(HEADER));
        player.sendMessage(plugin.getLang().getMessage(Messages.NO_NPC));
        return true;
    }

    public static boolean npcNotSelectedNM(Player player) {
        return CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)player) == null;
    }

    public static int getSelectedNpcId(Player player) {
        return CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)player).getId();
    }

    public static void setUpMetrics(Metrics metrics, FileConfiguration config) {
        metrics.addCustomChart(new Metrics.SimplePie("lang", () -> {
            switch (Objects.requireNonNull(config.getString("lang", "en")).toLowerCase()) {
                case "en": {
                    return "English";
                }
                case "bg": {
                    return "Bulgarian";
                }
                case "fr": {
                    return "French";
                }
                case "no": {
                    return "Norwegian";
                }
                case "pt": {
                    return "Portuguese";
                }
                case "Ro": {
                    return "Romanian";
                }
                case "ch": {
                    return "Chinese";
                }
            }
            return "Other";
        }));
        metrics.addCustomChart(new Metrics.SimplePie("cooldown_display", () -> {
            switch (Objects.requireNonNull(config.getString("cooldown-time-display", "MEDIUM")).toLowerCase()) {
                case "FULL": {
                    return "Full";
                }
                case "SMALL": {
                    return "Small";
                }
            }
            return "Medium";
        }));
    }

    public static int getDefaultCooldown(CitizensCMD plugin) {
        return plugin.getConfig().getInt("default-cooldown");
    }

    public static long getSecondsDifference(long storedTime) {
        return TimeUnit.SECONDS.convert(System.currentTimeMillis() - storedTime, TimeUnit.MILLISECONDS);
    }

    public static void disablePlugin(CitizensCMD plugin) {
        MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r &cCitizens &7is needed for this plugin to work!"));
        MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r &cCitizens.jar &7is not installed on the server!"));
        MessageUtils.info(MessageUtils.color("&f[&3Citizens&cCMD&f]&r &cDisabling CitizensCMD..."));
        Bukkit.getServer().getPluginManager().disablePlugin((Plugin)plugin);
    }

    private static void changeServer(CitizensCMD plugin, Player player, String server) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF("Connect");
            dataOutputStream.writeUTF(server);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendPluginMessage((Plugin)plugin, "BungeeCord", byteArrayOutputStream.toByteArray());
    }

    public static void doCommands(CitizensCMD plugin, NPC npc, Player player, EnumTypes.ClickType clickType) {
        ArrayList<String> permissions = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>();
        for (String list : plugin.getDataHandler().getClickCommandsData(npc.getId(), clickType)) {
            Pattern pattern = Pattern.compile("\\[([^]]*)] (.*)");
            Matcher matcher = pattern.matcher(list);
            if (!matcher.find()) continue;
            permissions.add(matcher.group(1));
            String command = matcher.group(2);
            if (command.contains("%p%")) {
                command = command.replace("%p%", player.getName());
            }
            if (command.contains("%player%")) {
                command = command.replace("%player%", player.getName());
            }
            if (plugin.papiEnabled()) {
                commands.add(PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)command));
                continue;
            }
            commands.add(command);
        }
        if (permissions.size() != commands.size()) {
            return;
        }
        block15: for (int i = 0; i < permissions.size(); ++i) {
            Pattern pattern;
            Matcher matcher;
            double delay = 0.0;
            if (((String)permissions.get(i)).contains("(") && (matcher = (pattern = Pattern.compile("(.*)\\(([^]]*)\\)")).matcher((CharSequence)permissions.get(i))).find()) {
                delay = Double.parseDouble(matcher.group(2));
                String permission = matcher.group(1);
                permissions.set(i, permission);
            }
            int finalI = i;
            switch (((String)permissions.get(i)).toLowerCase()) {
                case "console": {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> plugin.getServer().dispatchCommand((CommandSender)plugin.getServer().getConsoleSender(), (String)commands.get(finalI)), (long)((int)delay * 20));
                    continue block15;
                }
                case "none": {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> player.chat("/" + (String)commands.get(finalI)), (long)((int)delay * 20));
                    continue block15;
                }
                case "server": {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> Util.changeServer(plugin, player, (String)commands.get(finalI)), (long)((int)delay * 20));
                    continue block15;
                }
                case "message": {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                        String finalMessage;
                        if (((String)commands.get(finalI)).contains("{display}")) {
                            String tmpStr = ((String)commands.get(finalI)).replace("{display}", plugin.getLang().getMessage(Messages.MESSAGE_DISPLAY));
                            finalMessage = tmpStr.replace("{name}", npc.getFullName());
                        } else {
                            finalMessage = (String)commands.get(finalI);
                        }
                        player.sendMessage(MessageUtils.color(finalMessage));
                    }, (long)((int)delay * 20));
                    continue block15;
                }
                case "sound": {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                        Pattern pattern = Pattern.compile("(\\w+)\\s([\\d.]+)\\s([\\d.]+)");
                        Matcher matcher = pattern.matcher((CharSequence)commands.get(finalI));
                        if (matcher.find() && Util.soundExists(matcher.group(1))) {
                            player.playSound(player.getLocation(), Sound.valueOf((String)matcher.group(1)), Float.parseFloat(matcher.group(2)), Float.parseFloat(matcher.group(3)));
                        }
                    }, (long)((int)delay * 20));
                    continue block15;
                }
                default: {
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                        plugin.getPermissionsManager().setPermission(player, (String)permissions.get(finalI));
                        player.chat("/" + (String)commands.get(finalI));
                        plugin.getPermissionsManager().unsetPermission(player, (String)permissions.get(finalI));
                    }, (long)((int)delay * 20));
                }
            }
        }
    }

    public static String getFormattedTime(CitizensCMD plugin, long seconds, DisplayFormat format) {
        String secondFormat;
        String minuteFormat;
        String hourFormat;
        String dayFormat;
        String dayPlural = "";
        String hourPlural = "";
        String minutePlural = "";
        String secondPlural = "";
        TimeUtil timeUtil = new TimeUtil(seconds);
        String[] messagesString = new String[]{plugin.getLang().getMessage(Messages.SECONDS), plugin.getLang().getMessage(Messages.MINUTES), plugin.getLang().getMessage(Messages.HOURS), plugin.getLang().getMessage(Messages.DAYS)};
        String[] shorts = new String[4];
        String[] mediums = new String[4];
        String[] fulls = new String[4];
        Pattern pattern = Pattern.compile("\\[([^]]*)], \\[([^]]*)], \\[([^]]*)]");
        for (int i = 0; i < messagesString.length; ++i) {
            Matcher matcher = pattern.matcher(messagesString[i]);
            if (!matcher.find()) continue;
            shorts[i] = matcher.group(1);
            mediums[i] = matcher.group(2);
            fulls[i] = matcher.group(3);
        }
        switch (format) {
            case MEDIUM: {
                String[] mediumsAfter = new String[4];
                String[] mediumsPlurals = new String[4];
                Pattern patternMediums = Pattern.compile("([^]]*)\\(([^]]*)\\)");
                for (int i = 0; i < mediums.length; ++i) {
                    if (mediums[i].contains("(") && mediums[i].contains(")")) {
                        Matcher matcher = patternMediums.matcher(mediums[i]);
                        if (!matcher.find()) continue;
                        mediumsAfter[i] = matcher.group(1);
                        mediumsPlurals[i] = matcher.group(2);
                        continue;
                    }
                    mediumsAfter[i] = mediums[i];
                    mediumsPlurals[i] = "";
                }
                dayFormat = " " + mediumsAfter[3];
                dayPlural = mediumsPlurals[3];
                hourFormat = " " + mediumsAfter[2];
                hourPlural = mediumsPlurals[2];
                minuteFormat = " " + mediumsAfter[1];
                minutePlural = mediumsPlurals[1];
                secondFormat = " " + mediumsAfter[0];
                secondPlural = mediumsPlurals[0];
                break;
            }
            case FULL: {
                String[] fullsAfter = new String[4];
                String[] fullsPlurals = new String[4];
                Pattern patternFulls = Pattern.compile("([^]]*)\\(([^]]*)\\)");
                for (int i = 0; i < fulls.length; ++i) {
                    if (fulls[i].contains("(") && fulls[i].contains(")")) {
                        Matcher matcher = patternFulls.matcher(fulls[i]);
                        if (!matcher.find()) continue;
                        fullsAfter[i] = matcher.group(1);
                        fullsPlurals[i] = matcher.group(2);
                        continue;
                    }
                    fullsAfter[i] = fulls[i];
                    fullsPlurals[i] = "";
                }
                dayFormat = " " + fullsAfter[3];
                dayPlural = fullsPlurals[3];
                hourFormat = " " + fullsAfter[2];
                hourPlural = fullsPlurals[2];
                minuteFormat = " " + fullsAfter[1];
                minutePlural = fullsPlurals[1];
                secondFormat = " " + fullsAfter[0];
                secondPlural = fullsPlurals[0];
                break;
            }
            default: {
                dayFormat = shorts[3];
                hourFormat = shorts[2];
                minuteFormat = shorts[1];
                secondFormat = shorts[0];
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (timeUtil.getDays() != 0) {
            if (format != DisplayFormat.SHORT) {
                if (timeUtil.getDays() == 1) {
                    stringBuilder.append(timeUtil.getDays()).append(dayFormat).append(" ");
                } else {
                    stringBuilder.append(timeUtil.getDays()).append(dayFormat).append(dayPlural).append(" ");
                }
            } else {
                stringBuilder.append(timeUtil.getDays()).append(dayFormat).append(" ");
            }
        }
        if (timeUtil.getHours() != 0 || timeUtil.getDays() != 0) {
            if (format != DisplayFormat.SHORT) {
                if (timeUtil.getHours() == 1) {
                    stringBuilder.append(timeUtil.getHours()).append(hourFormat).append(" ");
                } else {
                    stringBuilder.append(timeUtil.getHours()).append(hourFormat).append(hourPlural).append(" ");
                }
            } else {
                stringBuilder.append(timeUtil.getHours()).append(hourFormat).append(" ");
            }
        }
        if (timeUtil.getMinutes() != 0 || timeUtil.getHours() != 0) {
            if (format != DisplayFormat.SHORT) {
                if (timeUtil.getMinutes() == 1) {
                    stringBuilder.append(timeUtil.getMinutes()).append(minuteFormat).append(" ");
                } else {
                    stringBuilder.append(timeUtil.getMinutes()).append(minuteFormat).append(minutePlural).append(" ");
                }
            } else {
                stringBuilder.append(timeUtil.getMinutes()).append(minuteFormat).append(" ");
            }
        }
        if (timeUtil.getSeconds() != 0 || timeUtil.getMinutes() != 0) {
            if (format != DisplayFormat.SHORT) {
                if (timeUtil.getSeconds() == 1) {
                    stringBuilder.append(timeUtil.getSeconds()).append(secondFormat);
                } else {
                    stringBuilder.append(timeUtil.getSeconds()).append(secondFormat).append(secondPlural);
                }
            } else {
                stringBuilder.append(timeUtil.getSeconds()).append(secondFormat);
            }
        }
        return stringBuilder.toString();
    }

    private static boolean soundExists(String soundName) {
        for (Sound sound : Sound.values()) {
            if (!sound.name().equalsIgnoreCase(soundName)) continue;
            return true;
        }
        return false;
    }
}

