/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.model.MojangProfileTextureMeta;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.google.gson.Gson;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class PropertyUtils {
    private static final Gson GSON = new Gson();

    public static String getSkinTextureUrl(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinProfileData(property).getTextures().getSKIN().getUrl();
    }

    public static SkinVariant getSkinVariant(@NotNull SkinProperty property) {
        MojangProfileTextureMeta meta = PropertyUtils.getSkinProfileData(property).getTextures().getSKIN().getMetadata();
        if (meta == null) {
            return SkinVariant.CLASSIC;
        }
        return meta.getModel().equalsIgnoreCase("slim") ? SkinVariant.SLIM : SkinVariant.CLASSIC;
    }

    public static String getSkinTextureUrlStripped(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinProfileData(property).getTextures().getSKIN().getStrippedUrl();
    }

    public static MojangProfileResponse getSkinProfileData(@NotNull SkinProperty property) {
        String decodedString = new String(Base64.getDecoder().decode(property.getValue()), StandardCharsets.UTF_8);
        return GSON.fromJson(decodedString, MojangProfileResponse.class);
    }
}

