/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.bukkit.command.SRBukkitCommand;
import net.skinsrestorer.bukkit.gui.SkinsGUI;
import net.skinsrestorer.bukkit.listener.ForceAliveListener;
import net.skinsrestorer.bukkit.paper.PaperTabCompleteEvent;
import net.skinsrestorer.bukkit.paper.PaperUtil;
import net.skinsrestorer.bukkit.spigot.SpigotUtil;
import net.skinsrestorer.bukkit.utils.BukkitSchedulerProvider;
import net.skinsrestorer.bukkit.utils.SchedulerProvider;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.bstats.bukkit.Metrics;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.gui.SharedGUI;
import net.skinsrestorer.shared.info.ClassInfo;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.provider.ProviderSelector;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SRBukkitAdapter
implements SRServerAdapter<JavaPlugin> {
    private final Injector injector;
    private final Server server;
    private final JavaPlugin pluginInstance;
    private final BukkitAudiences adventure;
    private final SchedulerProvider schedulerProvider;
    private final SRLogger logger;

    @Inject
    public SRBukkitAdapter(Injector injector, Server server, JavaPlugin pluginInstance, BukkitAudiences adventure) {
        this.injector = injector;
        this.server = server;
        this.pluginInstance = pluginInstance;
        this.adventure = adventure;
        this.logger = injector.getSingleton(SRLogger.class);
        this.schedulerProvider = ProviderSelector.builder(SchedulerProvider.class, this.logger).add((SchedulerProvider)((Object)"net.skinsrestorer.bukkit.folia.FoliaSchedulerProvider")).add(new BukkitSchedulerProvider()).buildAndGet();
    }

    @Override
    public Object createMetricsInstance() {
        return new Metrics(this.pluginInstance, 1669);
    }

    @Override
    public void sendMessageToChannel(SRPlayer player, byte[] data) {
        player.getAs(Player.class).sendPluginMessage((Plugin)this.pluginInstance, "sr:messagechannel", data);
    }

    @Override
    public boolean isPluginEnabled(String pluginName) {
        return this.server.getPluginManager().getPlugin(pluginName) != null;
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.schedulerProvider.runAsync(this.server, (Plugin)this.pluginInstance, runnable);
    }

    @Override
    public void runSync(Runnable runnable) {
        this.schedulerProvider.runSync(this.server, (Plugin)this.pluginInstance, runnable);
    }

    @Override
    public void runSyncToPlayer(SRPlayer player, Runnable runnable) {
        this.runSyncToPlayer(player.getAs(Player.class), runnable);
    }

    public void runSyncToPlayer(Player player, Runnable runnable) {
        this.schedulerProvider.runSyncToEntity(this.server, (Plugin)this.pluginInstance, (Entity)player, runnable);
    }

    @Override
    public boolean determineProxy() {
        if (ClassInfo.get().isSpigot() && SpigotUtil.isRealSpigot(this.server) && SpigotUtil.getSpigotConfig(this.server).getBoolean("settings.bungeecord")) {
            return true;
        }
        Path spigotFile = Paths.get("spigot.yml", new String[0]);
        if (Files.exists(spigotFile, new LinkOption[0]) && YamlConfiguration.loadConfiguration((File)spigotFile.toFile()).getBoolean("settings.bungeecord")) {
            return true;
        }
        if (ClassInfo.get().isPaper()) {
            Path oldPaperFile = Paths.get("paper.yml", new String[0]);
            if (Files.exists(oldPaperFile, new LinkOption[0]) && YamlConfiguration.loadConfiguration((File)oldPaperFile.toFile()).getBoolean("settings.velocity-support.enabled")) {
                return true;
            }
            YamlConfiguration config = PaperUtil.getPaperConfig(this.server);
            return config != null && (config.getBoolean("settings.velocity-support.enabled") || config.getBoolean("proxies.velocity.enabled"));
        }
        return false;
    }

    @Override
    public void openServerGUI(SRPlayer player, int page) {
        Inventory inventory = (Inventory)this.injector.getSingleton(SharedGUI.class).createGUI(this.injector.getSingleton(SkinsGUI.class), this.injector.getSingleton(SharedGUI.ServerGUIActions.class), player, page);
        this.runSyncToPlayer(player, () -> player.getAs(Player.class).openInventory(inventory));
    }

    @Override
    public void openProxyGUI(SRPlayer player, int page, Map<String, String> skinList) {
        Inventory inventory = this.injector.getSingleton(SkinsGUI.class).createGUI((Consumer<ClickEventInfo>)this.injector.getSingleton(SharedGUI.ProxyGUIActions.class), (SRForeign)player, page, skinList);
        this.runSyncToPlayer(player, () -> player.getAs(Player.class).openInventory(inventory));
    }

    @Override
    public Optional<SRPlayer> getPlayer(String name) {
        return Optional.ofNullable(this.server.getPlayer(name)).map(p -> this.injector.getSingleton(WrapperBukkit.class).player((Player)p));
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.schedulerProvider.runRepeatAsync(this.server, (Plugin)this.pluginInstance, runnable, delay, interval, timeUnit);
    }

    @Override
    public void extendLifeTime(JavaPlugin plugin, Object object) {
        this.server.getPluginManager().registerEvents((Listener)new ForceAliveListener(object), (Plugin)plugin);
    }

    @Override
    public String getPlatformVersion() {
        return this.server.getVersion();
    }

    @Override
    public String getPlatformName() {
        return this.server.getName();
    }

    @Override
    public String getPlatformVendor() {
        return this.server.getBukkitVersion();
    }

    @Override
    public Platform getPlatform() {
        return Platform.BUKKIT;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return Arrays.stream(this.server.getPluginManager().getPlugins()).map(plugin -> new PluginInfo(plugin.isEnabled(), plugin.getName(), plugin.getDescription().getVersion(), plugin.getDescription().getMain(), plugin.getDescription().getAuthors().toArray(new String[0]))).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return SkinApplierBukkit.getApplyAdapter().getSkinProperty(player.getAs(Player.class));
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers() {
        WrapperBukkit wrapper = this.injector.getSingleton(WrapperBukkit.class);
        return this.server.getOnlinePlayers().stream().map(wrapper::player).collect(Collectors.toList());
    }

    @Override
    public void registerCommand(SRRegisterPayload<SRCommandSender> payload) {
        SettingsManager settingsManager = this.injector.getSingleton(SettingsManager.class);
        WrapperBukkit wrapper = this.injector.getSingleton(WrapperBukkit.class);
        try {
            CommandMap commandMap = (CommandMap)ReflectionUtil.invokeMethod(this.server, "getCommandMap");
            SRBukkitCommand command = new SRBukkitCommand(payload, (Plugin)this.pluginInstance, this.injector.getSingleton(WrapperBukkit.class));
            if (settingsManager.getProperty(AdvancedConfig.ENABLE_PAPER_ASYNC_TAB_LISTENER).booleanValue() && ReflectionUtil.classExists("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent")) {
                this.server.getPluginManager().registerEvents((Listener)new PaperTabCompleteEvent(payload, wrapper::commandSender), (Plugin)this.pluginInstance);
            }
            commandMap.register(payload.getMeta().getRootName(), "skinsrestorer", (Command)command);
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe("Encountered a error while registering a command", e);
        }
    }

    @Override
    public void shutdownCleanup() {
        this.schedulerProvider.unregisterTasks(this.server, (Plugin)this.pluginInstance);
    }

    public JavaPlugin getPluginInstance() {
        return this.pluginInstance;
    }

    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    public SchedulerProvider getSchedulerProvider() {
        return this.schedulerProvider;
    }
}

