/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.gui;

import java.util.function.Consumer;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.xseries.XMaterial;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SkinsGUIHolder
implements InventoryHolder {
    private final int page;
    private final Consumer<ClickEventInfo> callback;
    private final WrapperBukkit wrapper;
    private Inventory inventory;

    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null || !currentItem.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = currentItem.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        this.callback.accept(new ClickEventInfo(this.getMaterialType(XMaterial.matchXMaterial(currentItem)), itemMeta.getDisplayName(), this.wrapper.player(player), this.page));
    }

    private ClickEventInfo.MaterialType getMaterialType(XMaterial material) {
        switch (material) {
            case PLAYER_HEAD: {
                return ClickEventInfo.MaterialType.HEAD;
            }
            case RED_STAINED_GLASS_PANE: {
                return ClickEventInfo.MaterialType.RED_PANE;
            }
            case GREEN_STAINED_GLASS_PANE: {
                return ClickEventInfo.MaterialType.GREEN_PANE;
            }
            case YELLOW_STAINED_GLASS_PANE: {
                return ClickEventInfo.MaterialType.YELLOW_PANE;
            }
        }
        return ClickEventInfo.MaterialType.UNKNOWN;
    }

    public SkinsGUIHolder(int page, Consumer<ClickEventInfo> callback, WrapperBukkit wrapper) {
        this.page = page;
        this.callback = callback;
        this.wrapper = wrapper;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }
}

