/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.skinrefresher;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.bukkit.entity.Player;

public final class PaperSkinRefresher
implements Consumer<Player> {
    private final Method refreshPlayerMethod;
    private final Consumer<Player> triggerHealthUpdate;

    public PaperSkinRefresher() throws InitializeException {
        try {
            this.refreshPlayerMethod = BukkitReflection.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]);
            this.refreshPlayerMethod.setAccessible(true);
            this.triggerHealthUpdate = player -> {
                try {
                    Object entityPlayer = BukkitReflection.getHandle(player, Object.class);
                    ReflectionUtil.invokeMethod(entityPlayer, "triggerHealthUpdate");
                }
                catch (ReflectiveOperationException e) {
                    player.resetMaxHealth();
                }
            };
        }
        catch (Exception e) {
            throw new InitializeException(e);
        }
    }

    @Override
    public void accept(Player player) {
        this.refreshPlayerMethod.invoke((Object)player, new Object[0]);
        this.triggerHealthUpdate.accept(player);
    }
}

