/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.SettingsManagerImpl;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationDataBuilder;
import net.skinsrestorer.shadow.configme.migration.MigrationService;
import net.skinsrestorer.shadow.configme.migration.PlainMigrationService;
import net.skinsrestorer.shadow.configme.resource.PropertyResource;
import net.skinsrestorer.shadow.configme.resource.YamlFileResource;
import net.skinsrestorer.shadow.configme.resource.YamlFileResourceOptions;
import net.skinsrestorer.shadow.configme.utils.Utils;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public final class SettingsManagerBuilder {
    private final PropertyResource resource;
    private ConfigurationData configurationData;
    @Nullable
    private MigrationService migrationService;

    private SettingsManagerBuilder(@NotNull PropertyResource resource) {
        this.resource = resource;
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull Path file) {
        return SettingsManagerBuilder.withYamlFile(file, YamlFileResourceOptions.builder().build());
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull File file) {
        return SettingsManagerBuilder.withYamlFile(file.toPath());
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull Path path, @NotNull YamlFileResourceOptions resourceOptions) {
        Utils.createFileIfNotExists(path);
        return new SettingsManagerBuilder(new YamlFileResource(path, resourceOptions));
    }

    @NotNull
    public static SettingsManagerBuilder withYamlFile(@NotNull File file, @NotNull YamlFileResourceOptions resourceOptions) {
        return SettingsManagerBuilder.withYamlFile(file.toPath(), resourceOptions);
    }

    @NotNull
    public static SettingsManagerBuilder withResource(@NotNull PropertyResource resource) {
        return new SettingsManagerBuilder(resource);
    }

    @SafeVarargs
    @NotNull
    public final SettingsManagerBuilder configurationData(Class<? extends SettingsHolder> ... classes) {
        this.configurationData = ConfigurationDataBuilder.createConfiguration(classes);
        return this;
    }

    @NotNull
    public SettingsManagerBuilder configurationData(@NotNull ConfigurationData configurationData) {
        this.configurationData = configurationData;
        return this;
    }

    @NotNull
    public SettingsManagerBuilder migrationService(@Nullable MigrationService migrationService) {
        this.migrationService = migrationService;
        return this;
    }

    @NotNull
    public SettingsManagerBuilder useDefaultMigrationService() {
        this.migrationService = new PlainMigrationService();
        return this;
    }

    @NotNull
    public SettingsManager create() {
        Objects.requireNonNull(this.resource, "resource");
        Objects.requireNonNull(this.configurationData, "configurationData");
        return new SettingsManagerImpl(this.resource, this.configurationData, this.migrationService);
    }
}

