/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.configurationdata;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.skinsrestorer.shadow.configme.Comment;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.CommentsConfiguration;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationDataImpl;
import net.skinsrestorer.shadow.configme.configurationdata.PropertyListBuilder;
import net.skinsrestorer.shadow.configme.exception.ConfigMeException;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class ConfigurationDataBuilder {
    @NotNull
    protected PropertyListBuilder propertyListBuilder = new PropertyListBuilder();
    @NotNull
    protected CommentsConfiguration commentsConfiguration = new CommentsConfiguration();

    protected ConfigurationDataBuilder() {
    }

    @SafeVarargs
    @NotNull
    public static ConfigurationData createConfiguration(Class<? extends SettingsHolder> ... classes) {
        return ConfigurationDataBuilder.createConfiguration(Arrays.asList(classes));
    }

    @NotNull
    public static ConfigurationData createConfiguration(@NotNull Iterable<Class<? extends SettingsHolder>> classes) {
        ConfigurationDataBuilder builder = new ConfigurationDataBuilder();
        return builder.collectData(classes);
    }

    @NotNull
    public static ConfigurationData createConfiguration(@NotNull List<? extends Property<?>> properties) {
        return new ConfigurationDataImpl(properties, Collections.emptyMap(), Collections.emptyList());
    }

    @NotNull
    public static ConfigurationData createConfiguration(@NotNull List<? extends Property<?>> properties, @NotNull CommentsConfiguration commentsConfiguration) {
        return new ConfigurationDataImpl(properties, commentsConfiguration.getAllComments(), commentsConfiguration.getFooterComments());
    }

    @NotNull
    protected ConfigurationData collectData(@NotNull Iterable<Class<? extends SettingsHolder>> classes) {
        for (Class<? extends SettingsHolder> clazz : classes) {
            this.collectProperties(clazz);
            this.collectSectionComments(clazz);
        }
        return new ConfigurationDataImpl(this.propertyListBuilder.create(), this.commentsConfiguration.getAllComments(), this.commentsConfiguration.getFooterComments());
    }

    protected void collectProperties(@NotNull Class<?> clazz) {
        this.findFieldsToProcess(clazz).forEach(field -> {
            Property<?> property = this.getPropertyField((Field)field);
            if (property != null) {
                this.propertyListBuilder.add(property);
                this.setCommentForPropertyField((Field)field, property.getPath());
            }
        });
    }

    protected void setCommentForPropertyField(@NotNull Field field, @NotNull String path) {
        Comment commentAnnotation = field.getAnnotation(Comment.class);
        if (commentAnnotation != null) {
            this.commentsConfiguration.setComment(path, commentAnnotation.value());
        }
    }

    @Nullable
    protected Property<?> getPropertyField(@NotNull Field field) {
        if (Property.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers())) {
            try {
                return (Property)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ConfigMeException("Could not fetch field '" + field.getName() + "' from class '" + field.getDeclaringClass().getSimpleName() + "'. Is it maybe not public?", e);
            }
        }
        return null;
    }

    protected void collectSectionComments(@NotNull Class<? extends SettingsHolder> clazz) {
        SettingsHolder settingsHolder = this.createSettingsHolderInstance(clazz);
        settingsHolder.registerComments(this.commentsConfiguration);
    }

    @NotNull
    protected <T extends SettingsHolder> T createSettingsHolderInstance(@NotNull Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((SettingsHolder)constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ConfigMeException("Expected no-args constructor to be available for " + clazz, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ConfigMeException("Could not create instance of " + clazz, e);
        }
    }

    @NotNull
    protected Stream<Field> findFieldsToProcess(@NotNull Class<?> clazz) {
        if (Object.class.equals(clazz.getSuperclass())) {
            return Arrays.stream(clazz.getDeclaredFields());
        }
        ArrayList classes = new ArrayList();
        for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            classes.add(currentClass);
        }
        Collections.reverse(classes);
        return classes.stream().map(Class::getDeclaredFields).flatMap(Arrays::stream);
    }
}

