/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.properties;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import net.skinsrestorer.shadow.configme.properties.BaseProperty;
import net.skinsrestorer.shadow.configme.properties.convertresult.ConvertErrorRecorder;
import net.skinsrestorer.shadow.configme.properties.types.PropertyType;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class ArrayProperty<T>
extends BaseProperty<T[]> {
    private final PropertyType<T> type;
    private final IntFunction<T[]> arrayProducer;

    public ArrayProperty(@NotNull String path, T @NotNull [] defaultValue, @NotNull PropertyType<T> type, @NotNull IntFunction<T[]> arrayProducer) {
        super(path, defaultValue);
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(arrayProducer, "arrayProducer");
        this.type = type;
        this.arrayProducer = arrayProducer;
    }

    @Override
    protected T @Nullable [] getFromReader(@NotNull PropertyReader reader, @NotNull ConvertErrorRecorder errorRecorder) {
        Object object = reader.getObject(this.getPath());
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.stream().map(elem -> this.type.convert(elem, errorRecorder)).filter(Objects::nonNull).toArray(this.arrayProducer);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toExportValue(T @NotNull [] value) {
        Object[] array = new Object[value.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.type.toExportValue(value[i]);
        }
        return array;
    }
}

