/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Connection;
import net.skinsrestorer.shadow.mariadb.MariaDbXid;
import net.skinsrestorer.shadow.mariadb.util.StringUtils;

public class MariaDbPoolConnection
implements PooledConnection,
XAConnection {
    private final Connection connection;
    private final List<ConnectionEventListener> connectionEventListeners;
    private final List<StatementEventListener> statementEventListeners;

    public MariaDbPoolConnection(Connection connection) {
        this.connection = connection;
        this.connection.setPoolConnection(this);
        this.statementEventListeners = new CopyOnWriteArrayList<StatementEventListener>();
        this.connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    }

    public static String xidToString(Xid xid) {
        return "0x" + StringUtils.byteArrayToHexString(xid.getGlobalTransactionId()) + ",0x" + StringUtils.byteArrayToHexString(xid.getBranchQualifier()) + ",0x" + Integer.toHexString(xid.getFormatId());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    public void fireStatementClosed(PreparedStatement statement) {
        StatementEvent event = new StatementEvent(this, statement);
        for (StatementEventListener listener : this.statementEventListeners) {
            listener.statementClosed(event);
        }
    }

    public void fireStatementErrorOccurred(PreparedStatement statement, SQLException returnEx) {
        StatementEvent event = new StatementEvent(this, statement, returnEx);
        for (StatementEventListener listener : this.statementEventListeners) {
            listener.statementErrorOccurred(event);
        }
    }

    public void fireConnectionClosed(ConnectionEvent event) {
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionClosed(event);
        }
    }

    public void fireConnectionErrorOccurred(SQLException returnEx) {
        ConnectionEvent event = new ConnectionEvent(this, returnEx);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(event);
        }
    }

    @Override
    public void close() throws SQLException {
        this.fireConnectionClosed(new ConnectionEvent(this));
        this.connection.setPoolConnection(null);
        this.connection.close();
    }

    @Override
    public XAResource getXAResource() {
        return new MariaDbXAResource();
    }

    private class MariaDbXAResource
    implements XAResource {
        private MariaDbXAResource() {
        }

        private String flagsToString(int flags) {
            switch (flags) {
                case 0x200000: {
                    return "JOIN";
                }
                case 0x40000000: {
                    return "ONE PHASE";
                }
                case 0x8000000: {
                    return "RESUME";
                }
                case 0x2000000: {
                    return "SUSPEND";
                }
            }
            return "";
        }

        private XAException mapXaException(SQLException sqle) {
            int xaErrorCode;
            switch (sqle.getErrorCode()) {
                case 1397: {
                    xaErrorCode = -4;
                    break;
                }
                case 1398: {
                    xaErrorCode = -5;
                    break;
                }
                case 1399: {
                    xaErrorCode = -7;
                    break;
                }
                case 1400: {
                    xaErrorCode = -9;
                    break;
                }
                case 1401: {
                    xaErrorCode = -3;
                    break;
                }
                case 1402: {
                    xaErrorCode = 100;
                    break;
                }
                default: {
                    xaErrorCode = 0;
                }
            }
            XAException xaException = xaErrorCode != 0 ? new XAException(xaErrorCode) : new XAException(sqle.getMessage());
            xaException.initCause(sqle);
            return xaException;
        }

        private void execute(String command) throws XAException {
            try {
                MariaDbPoolConnection.this.connection.createStatement().execute(command);
            }
            catch (SQLException sqle) {
                throw this.mapXaException(sqle);
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            this.execute("XA COMMIT " + MariaDbPoolConnection.xidToString(xid) + (onePhase ? " ONE PHASE" : ""));
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (flags != 0x4000000 && flags != 0x2000000 && flags != 0x20000000) {
                throw new XAException(-5);
            }
            this.execute("XA END " + MariaDbPoolConnection.xidToString(xid) + " " + this.flagsToString(flags));
        }

        @Override
        public void forget(Xid xid) {
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        public Configuration getConf() {
            return MariaDbPoolConnection.this.connection.getContext().getConf();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            if (xaResource instanceof MariaDbXAResource) {
                MariaDbXAResource other = (MariaDbXAResource)xaResource;
                return other.getConf().equals(this.getConf());
            }
            return false;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            this.execute("XA PREPARE " + MariaDbPoolConnection.xidToString(xid));
            return 0;
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            if ((flags & 0x1000000) == 0 && (flags & 0x800000) == 0 && flags != 0) {
                throw new XAException(-5);
            }
            if ((flags & 0x1000000) == 0) {
                return new MariaDbXid[0];
            }
            try {
                ResultSet rs = MariaDbPoolConnection.this.connection.createStatement().executeQuery("XA RECOVER");
                ArrayList<MariaDbXid> xidList = new ArrayList<MariaDbXid>();
                while (rs.next()) {
                    int formatId = rs.getInt(1);
                    int len1 = rs.getInt(2);
                    int len2 = rs.getInt(3);
                    byte[] arr = rs.getBytes(4);
                    byte[] globalTransactionId = new byte[len1];
                    byte[] branchQualifier = new byte[len2];
                    System.arraycopy(arr, 0, globalTransactionId, 0, len1);
                    System.arraycopy(arr, len1, branchQualifier, 0, len2);
                    xidList.add(new MariaDbXid(formatId, globalTransactionId, branchQualifier));
                }
                Xid[] xids = new Xid[xidList.size()];
                xidList.toArray(xids);
                return xids;
            }
            catch (SQLException sqle) {
                throw this.mapXaException(sqle);
            }
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.execute("XA ROLLBACK " + MariaDbPoolConnection.xidToString(xid));
        }

        @Override
        public boolean setTransactionTimeout(int i) {
            return false;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            if (flags != 0x200000 && flags != 0x8000000 && flags != 0) {
                throw new XAException(-5);
            }
            this.execute("XA START " + MariaDbPoolConnection.xidToString(xid) + " " + this.flagsToString(flags));
        }
    }
}

