/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.authentication.addon;

import java.io.IOException;
import java.sql.SQLException;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.plugin.AuthenticationPlugin;
import net.skinsrestorer.shadow.mariadb.plugin.authentication.addon.gssapi.GssUtility;
import net.skinsrestorer.shadow.mariadb.plugin.authentication.addon.gssapi.GssapiAuth;
import net.skinsrestorer.shadow.mariadb.plugin.authentication.addon.gssapi.StandardGssapiAuthentication;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private byte[] seed;
    private String optionServicePrincipalName;

    @Override
    public String type() {
        return "auth_gssapi_client";
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Configuration conf) {
        this.seed = seed;
        this.optionServicePrincipalName = conf.servicePrincipalName();
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context) throws IOException, SQLException {
        StandardReadableByteBuf buf = new StandardReadableByteBuf(this.seed, this.seed.length);
        String serverSpn = buf.readStringNullEnd();
        String servicePrincipalName = this.optionServicePrincipalName != null ? this.optionServicePrincipalName : serverSpn;
        String mechanisms = buf.readStringNullEnd();
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(out, in, servicePrincipalName, mechanisms);
        return in.readReusablePacket();
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

