/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.multilib;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.skinsrestorer.shadow.multilib.util.DataStorageCache;
import org.bukkit.plugin.Plugin;

public interface DataStorageImpl {
    public CompletableFuture<String> get(String var1);

    default public CompletableFuture<String> get(String key, String def) {
        return this.get(key).thenApply(value -> value != null ? value : def);
    }

    default public CompletableFuture<Long> getLong(String key) {
        return this.get(key).thenApply(Long::parseLong);
    }

    default public CompletableFuture<Long> getLong(String key, long def) {
        return this.getLong(key).exceptionally(throwable -> def);
    }

    default public CompletableFuture<Integer> getInt(String key) {
        return this.get(key).thenApply(Integer::parseInt);
    }

    default public CompletableFuture<Integer> getInt(String key, int def) {
        return this.getInt(key).exceptionally(throwable -> def);
    }

    default public CompletableFuture<Double> getDouble(String key) {
        return this.get(key).thenApply(Double::parseDouble);
    }

    default public CompletableFuture<Double> getDouble(String key, double def) {
        return this.getDouble(key).exceptionally(throwable -> def);
    }

    default public CompletableFuture<Map<String, String>> list() {
        return this.list(null);
    }

    public CompletableFuture<Map<String, String>> list(String var1);

    public CompletableFuture<String> set(String var1, String var2);

    default public CompletableFuture<Long> set(String key, long value) {
        return this.set(key, Long.toString(value)).thenApply(Long::parseLong);
    }

    default public CompletableFuture<Integer> set(String key, int value) {
        return this.set(key, Integer.toString(value)).thenApply(Integer::parseInt);
    }

    default public CompletableFuture<Double> set(String key, double value) {
        return this.set(key, Double.toString(value)).thenApply(Double::parseDouble);
    }

    public CompletableFuture<String> add(String var1, String var2);

    default public CompletableFuture<Long> add(String key, long increment) {
        return this.add(key, Long.toString(increment)).thenApply(Long::parseLong);
    }

    default public CompletableFuture<Integer> add(String key, int increment) {
        return this.add(key, Integer.toString(increment)).thenApply(Integer::parseInt);
    }

    default public CompletableFuture<Double> add(String key, double increment) {
        return this.add(key, Double.toString(increment)).thenApply(Double::parseDouble);
    }

    default public DataStorageCache createCache(Plugin plugin, String keyPrefix) {
        return new DataStorageCache(plugin, keyPrefix, this);
    }
}

